/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.util;

import com.mulesoft.connectivity.rest.commons.api.configuration.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.operation.HttpResponseAttributes;
import com.mulesoft.connectivity.rest.commons.internal.util.RestRequestBuilder;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.internal.streaming.bytes.ByteArrayCursorStreamProvider;
import org.mule.runtime.extension.api.runtime.operation.Result;

public class RequestStreamingUtils {
    public static Result<TypedValue<String>, HttpResponseAttributes> doRequestAndConsumeString(RestConnection connection, RestConfiguration config, RestRequestBuilder requestBuilder, MediaType defaultResponseMediaType) {
        MediaType mediaType = RequestStreamingUtils.resolveDefaultResponseMediaType(config, defaultResponseMediaType);
        Result<InputStream, HttpResponseAttributes> result = RequestStreamingUtils.doRequest(connection, config, requestBuilder, mediaType);
        TypedValue<String> rawContent = RestSdkUtils.consumeStringAndClose(result.getOutput(), result.getMediaType().orElse(mediaType), RestSdkUtils.resolveCharset(result.getMediaType(), mediaType));
        return Result.builder().output(rawContent).mediaType(MediaType.APPLICATION_JAVA).attributes(result.getAttributes().orElse(null)).attributesMediaType((MediaType)result.getAttributesMediaType().orElse(null)).build();
    }

    public static Result<InputStream, HttpResponseAttributes> doRequest(RestConnection connection, RestConfiguration config, RestRequestBuilder requestBuilder, MediaType mediaType) {
        Result<InputStream, HttpResponseAttributes> result;
        try {
            result = connection.request(requestBuilder, RequestStreamingUtils.getConfigResponseTimeout(config), mediaType, null).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)cause.getMessage()), cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MuleRuntimeException((Throwable)e);
        }
        return result;
    }

    private static int getConfigResponseTimeout(RestConfiguration config) {
        return (int)config.getResponseTimeoutUnit().toMillis(config.getResponseTimeout().intValue());
    }

    private static MediaType resolveDefaultResponseMediaType(RestConfiguration config, MediaType defaultResponseMediaType) {
        MediaType mediaType = defaultResponseMediaType;
        if (!mediaType.getCharset().isPresent()) {
            mediaType = mediaType.withCharset(config.getCharset());
        }
        return mediaType;
    }

    public static TypedValue<CursorStreamProvider> getCursorStreamProviderValueFromSplitResult(TypedValue<?> typedValue) {
        if (typedValue.getValue() instanceof CursorStreamProvider) {
            return new TypedValue((Object)((CursorStreamProvider)typedValue.getValue()), typedValue.getDataType());
        }
        if (typedValue.getValue() instanceof String) {
            return new TypedValue((Object)new ByteArrayCursorStreamProvider(((String)typedValue.getValue()).getBytes()), typedValue.getDataType());
        }
        throw new IllegalArgumentException("Could not create CursorStreamProvider for type: " + typedValue.getValue().getClass());
    }
}

