/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler;

import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.ParsingContext;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.RestHandlerManager;
import com.mulesoft.connectivity.rest.commons.internal.metadatamodel.handler.SchemaHandler;
import com.mulesoft.connectivity.rest.commons.internal.util.RestSdkUtils;
import java.util.List;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TupleTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

public class ArrayHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof ArraySchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager handlerManager, ParsingContext parsingContext) {
        Schema arrayType;
        String title;
        ArraySchema arraySchema = (ArraySchema)schema;
        if (arraySchema.getItemSchemas() != null && !arraySchema.getItemSchemas().isEmpty()) {
            String title2;
            List itemSchemas = arraySchema.getItemSchemas();
            TupleTypeBuilder tupleType = root.tupleType();
            String description = arraySchema.getDescription();
            if (RestSdkUtils.isNotBlank(description)) {
                tupleType.description(description);
            }
            if (RestSdkUtils.isNotBlank(title2 = arraySchema.getTitle())) {
                tupleType.label(title2);
            }
            for (Schema itemSchema : itemSchemas) {
                tupleType.of(handlerManager.handle(itemSchema, parsingContext));
            }
            return tupleType;
        }
        ArrayTypeBuilder arrayMetadataBuilder = root.arrayType();
        String description = arraySchema.getDescription();
        if (RestSdkUtils.isNotBlank(description)) {
            arrayMetadataBuilder.description(description);
        }
        if (RestSdkUtils.isNotBlank(title = arraySchema.getTitle())) {
            arrayMetadataBuilder.label(title);
        }
        if (arraySchema.needsUniqueItems()) {
            arrayMetadataBuilder.uniques();
        }
        Integer min = null;
        Integer max = null;
        if (arraySchema.getMinItems() != null && arraySchema.getMinItems() > 0) {
            min = arraySchema.getMinItems();
        }
        if (arraySchema.getMaxItems() != null && arraySchema.getMaxItems() > 0) {
            max = arraySchema.getMaxItems();
        }
        if (min != null || max != null) {
            arrayMetadataBuilder.boundary((Number)min, max);
        }
        if ((arrayType = arraySchema.getAllItemSchema()) != null) {
            arrayMetadataBuilder.of(handlerManager.handle(arrayType, parsingContext));
        } else {
            arrayMetadataBuilder.of().anyType();
        }
        String id = arraySchema.getId();
        if (RestSdkUtils.isNotBlank(id)) {
            arrayMetadataBuilder.id(id);
        }
        return arrayMetadataBuilder;
    }
}

