/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadata.handler;

import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.ParsingContext;
import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.RestHandlerManager;
import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.SchemaHandler;
import java.util.Collection;
import org.everit.json.schema.CombinedSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.IntersectionTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.builder.UnionTypeBuilder;

public class CombinedHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof CombinedSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager restHandlerManager, ParsingContext parsingContext) {
        CombinedSchema combinedSchema = (CombinedSchema)schema;
        Collection subschemas = combinedSchema.getSubschemas();
        if (combinedSchema.getCriterion() == CombinedSchema.ANY_CRITERION || combinedSchema.getCriterion() == CombinedSchema.ONE_CRITERION) {
            UnionTypeBuilder unionType = root.unionType();
            for (Schema subschema : subschemas) {
                unionType.of(restHandlerManager.handle(subschema, parsingContext));
            }
            return unionType;
        }
        if (combinedSchema.getCriterion() == CombinedSchema.ALL_CRITERION) {
            IntersectionTypeBuilder intersectionType = root.intersectionType();
            for (Schema subschema : subschemas) {
                intersectionType.of(restHandlerManager.handle(subschema, parsingContext));
            }
            return intersectionType;
        }
        return root.anyType();
    }
}

