/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.commons.internal.metadata.handler;

import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.ParsingContext;
import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.RestHandlerManager;
import com.mulesoft.connectivity.rest.commons.internal.metadata.handler.SchemaHandler;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.everit.json.schema.ObjectSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

public class ObjectHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof ObjectSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, RestHandlerManager restHandlerManager, ParsingContext parsingContext) {
        String id;
        String title;
        ObjectSchema objectSchema = (ObjectSchema)schema;
        ObjectTypeBuilder objectMetadataBuilder = root.objectType();
        parsingContext.registerBuilder((Schema)objectSchema, (TypeBuilder<?>)objectMetadataBuilder);
        String description = objectSchema.getDescription();
        if (this.isNotEmpty(description)) {
            objectMetadataBuilder.description(description);
        }
        if (this.isNotEmpty(title = objectSchema.getTitle())) {
            objectMetadataBuilder.label(title);
        }
        if (this.isNotEmpty(id = objectSchema.getId())) {
            objectMetadataBuilder.id(id);
        }
        Set properties = objectSchema.getPropertySchemas().entrySet();
        List requiredProperties = objectSchema.getRequiredProperties();
        for (Map.Entry property : properties) {
            ObjectFieldTypeBuilder field = objectMetadataBuilder.addField().key((String)property.getKey());
            field.required(requiredProperties.contains(property.getKey()));
            Schema value = (Schema)property.getValue();
            field.value(restHandlerManager.handle(value, parsingContext));
        }
        Map patternProperties = objectSchema.getPatternProperties();
        Collection entries = patternProperties.entrySet().stream().sorted((o1, o2) -> ((Pattern)o1.getKey()).toString().compareTo(((Pattern)o2.getKey()).toString())).collect(Collectors.toList());
        for (Map.Entry patternSchemaEntry : entries) {
            ObjectFieldTypeBuilder field = objectMetadataBuilder.addField();
            field.key((Pattern)patternSchemaEntry.getKey());
            Schema value = (Schema)patternSchemaEntry.getValue();
            field.value(restHandlerManager.handle(value, parsingContext));
        }
        if (objectSchema.permitsAdditionalProperties()) {
            objectMetadataBuilder.openWith(restHandlerManager.handle(objectSchema.getSchemaOfAdditionalProperties(), parsingContext));
        }
        return objectMetadataBuilder;
    }

    private boolean isNotEmpty(String description) {
        return description != null && !description.isEmpty();
    }
}

