/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.persistence.model.provider;

import com.mulesoft.connectivity.mule.persistence.model.provider.SerializedTypeReferenceExpression;
import java.util.Objects;

public class SerializedObjectFieldSelector
extends SerializedTypeReferenceExpression {
    private final boolean relative;
    private final String[] path;

    public SerializedObjectFieldSelector(boolean relative, String[] path) {
        this.relative = relative;
        this.path = Objects.requireNonNull(path, "path cannot be null");
    }

    public static SerializedObjectFieldSelector create(String value) {
        if (Objects.requireNonNull(value, "Value cannot be null").isBlank()) {
            throw new IllegalArgumentException("Value cannot be empty");
        }
        boolean relative = !value.startsWith("/");
        String[] path = value.replaceAll("^/+", "").split("/");
        return new SerializedObjectFieldSelector(relative, path);
    }

    public boolean isRelative() {
        return this.relative;
    }

    public String[] getPath() {
        return this.path;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.relative) {
            sb.append("/");
        }
        for (int i = 0; i < this.path.length; ++i) {
            if (i > 0) {
                sb.append("/");
            }
            sb.append(this.path[i]);
        }
        return sb.toString();
    }
}

