/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.persistence.model.connection.oauth;

import com.mulesoft.connectivity.mule.persistence.model.connection.oauth.OAuth2AuthenticationType;
import java.util.List;
import java.util.Objects;

public class OAuth2ClientCredentialsAuthenticationType
extends OAuth2AuthenticationType {
    private final String tokenUrl;

    public OAuth2ClientCredentialsAuthenticationType(String refreshUrl, List<String> scopes, String tokenUrl) {
        super(OAuth2AuthenticationType.GrantType.clientCredentials, refreshUrl, scopes);
        this.tokenUrl = Objects.requireNonNull(tokenUrl, "'tokenUrl' cannot be null");
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @Override
    public String toString() {
        return "OAuth2AuthenticationType{  subType='" + String.valueOf(this.getSubType()) + "', tokenUrl='" + this.tokenUrl + "', refreshUrl='" + this.getRefreshUrl() + "', scopes=" + String.valueOf(this.getScopes()) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuth2ClientCredentialsAuthenticationType that = (OAuth2ClientCredentialsAuthenticationType)o;
        return Objects.equals(this.tokenUrl, that.tokenUrl) && Objects.equals(this.getRefreshUrl(), that.getRefreshUrl()) && Objects.equals(this.getScopes(), that.getScopes());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tokenUrl, this.getRefreshUrl(), this.getScopes());
    }
}

