/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.persistence.model.connection;

import com.mulesoft.connectivity.mule.persistence.model.SerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.HttpAuthenticationType;
import com.mulesoft.connectivity.mule.persistence.model.connection.MuleTestConnectionSerializableModel;
import org.mule.metadata.api.model.MetadataType;

public class MuleConnectionProviderSerializableModel
extends SerializableModel {
    protected final MuleTestConnectionSerializableModel testConnection;
    protected final HttpAuthenticationType authenticationType;
    protected final MetadataType inputType;
    protected final boolean hasExtensions;
    private final String authenticationTypeName;
    protected final String name;

    protected MuleConnectionProviderSerializableModel(MetadataType inputType, MuleTestConnectionSerializableModel testConnection, HttpAuthenticationType authenticationType, boolean hasExtensions, String name, String modelReference) {
        super(modelReference);
        this.testConnection = testConnection;
        this.authenticationType = authenticationType;
        this.inputType = inputType;
        this.hasExtensions = hasExtensions;
        this.name = name;
        this.authenticationTypeName = authenticationType.getType().name().toLowerCase() + authenticationType.getSubType().map(subType -> "-" + subType.toLowerCase()).orElse("");
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getAuthenticationTypeName() {
        return this.authenticationTypeName;
    }

    public MuleTestConnectionSerializableModel getTestConnection() {
        return this.testConnection;
    }

    public HttpAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public MetadataType getInputType() {
        return this.inputType;
    }

    public boolean hasExtensions() {
        return this.hasExtensions;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "MuleConnectionProviderSerializableModel{inputType='" + String.valueOf(this.inputType) + "', testConnection=" + String.valueOf(this.testConnection) + ", authenticationType=" + String.valueOf(this.authenticationType) + ", hasExtensions=" + this.hasExtensions + ", name='" + this.name + "', modelReference='" + this.modelReference + "'}";
    }

    public static class Builder
    extends SerializableModel.Builder<Builder> {
        private MetadataType inputType;
        private MuleTestConnectionSerializableModel testConnection;
        private HttpAuthenticationType authenticationType;
        private boolean hasExtensions;
        private String name;

        private Builder() {
        }

        public Builder inputType(MetadataType inputType) {
            this.inputType = inputType;
            return this;
        }

        public Builder testConnection(MuleTestConnectionSerializableModel testConnection) {
            this.testConnection = testConnection;
            return this;
        }

        public Builder authenticationType(HttpAuthenticationType authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public Builder hasExtensions(boolean hasExtensions) {
            this.hasExtensions = hasExtensions;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public MuleConnectionProviderSerializableModel build() {
            return new MuleConnectionProviderSerializableModel(this.inputType, this.testConnection, this.authenticationType, this.hasExtensions, this.name, this.modelReference);
        }
    }
}

