/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.mule.persistence.model;

import com.mulesoft.connectivity.mule.persistence.model.MuleOperationSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleSourceSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.MuleValueProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.SerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.MuleConnectionProviderSerializableModel;
import com.mulesoft.connectivity.mule.persistence.model.connection.MuleTestConnectionSerializableModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.meta.Category;

public class MuleConnectorSerializableModel
extends SerializableModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String displayName;
    private final String version;
    private final String description;
    private final String vendor;
    private final Category category;
    private final List<MuleConnectionProviderSerializableModel> connectionProviderModelList;
    private final MuleTestConnectionSerializableModel testConnectionModel;
    private final List<MuleOperationSerializableModel> operationModelList;
    private final List<MuleSourceSerializableModel> sourceModelList;
    private final List<MuleValueProviderSerializableModel> valueProviderModelList;

    protected MuleConnectorSerializableModel(String name, String displayName, String version, String description, String vendor, Category category, List<MuleConnectionProviderSerializableModel> connectionProviderModelList, MuleTestConnectionSerializableModel testConnectionModel, List<MuleOperationSerializableModel> operationModelList, List<MuleSourceSerializableModel> sourceModelList, List<MuleValueProviderSerializableModel> valueProviderModelList, String modelReference) {
        super(modelReference);
        this.name = name;
        this.displayName = displayName;
        this.version = version;
        this.description = description;
        this.vendor = vendor;
        this.category = category;
        this.connectionProviderModelList = List.copyOf(connectionProviderModelList);
        this.testConnectionModel = testConnectionModel;
        this.operationModelList = List.copyOf(operationModelList);
        this.sourceModelList = List.copyOf(sourceModelList);
        this.valueProviderModelList = List.copyOf(valueProviderModelList);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getVersion() {
        return this.version;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVendor() {
        return this.vendor;
    }

    public List<MuleConnectionProviderSerializableModel> getConnections() {
        return this.connectionProviderModelList;
    }

    public MuleTestConnectionSerializableModel getTestConnection() {
        return this.testConnectionModel;
    }

    public List<MuleOperationSerializableModel> getOperations() {
        return this.operationModelList;
    }

    public List<MuleSourceSerializableModel> getSources() {
        return this.sourceModelList;
    }

    public List<MuleValueProviderSerializableModel> getValueProviders() {
        return this.valueProviderModelList;
    }

    public MuleValueProviderSerializableModel getValueProvider(String valueProviderReference) {
        return this.getValueProviders().stream().filter(provider -> provider.getName().equals(valueProviderReference)).findFirst().orElseThrow(() -> new IllegalStateException("Value provider not found: " + valueProviderReference));
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return "MuleConnectorSerializableModel{name='" + this.getName() + "'displayName='" + this.getDisplayName() + "'version='" + this.version + "'description='" + this.description + "'vendor='" + this.vendor + "'modelReference='" + this.modelReference + "'category=" + String.valueOf(this.category) + "'connections='" + String.valueOf(this.connectionProviderModelList) + "'testConnection='" + String.valueOf(this.testConnectionModel) + "'operations='" + String.valueOf(this.operationModelList) + "'sources='" + String.valueOf(this.sourceModelList) + "'valueProviders='" + String.valueOf(this.valueProviderModelList) + "'}";
    }

    public static class Builder
    extends SerializableModel.Builder<Builder> {
        private String name;
        private String displayName;
        private String version;
        private String description;
        private String vendor;
        private Category category;
        private List<MuleConnectionProviderSerializableModel> connectionProviderModelList = new ArrayList<MuleConnectionProviderSerializableModel>();
        private MuleTestConnectionSerializableModel testConnectionModel;
        private List<MuleOperationSerializableModel> operationModelList = new ArrayList<MuleOperationSerializableModel>();
        private List<MuleSourceSerializableModel> sourceModelList = new ArrayList<MuleSourceSerializableModel>();
        private List<MuleValueProviderSerializableModel> valueProvidersModelList = new ArrayList<MuleValueProviderSerializableModel>();

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder vendor(String vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder category(Category category) {
            this.category = category;
            return this;
        }

        public Builder connectionProviders(List<MuleConnectionProviderSerializableModel> connectionProviderModelList) {
            this.connectionProviderModelList = new ArrayList<MuleConnectionProviderSerializableModel>(connectionProviderModelList);
            return this;
        }

        public Builder addConnectionProvider(MuleConnectionProviderSerializableModel connectionProvider) {
            this.connectionProviderModelList.add(connectionProvider);
            return this;
        }

        public Builder operations(List<MuleOperationSerializableModel> operationModelList) {
            this.operationModelList = new ArrayList<MuleOperationSerializableModel>(operationModelList);
            return this;
        }

        public Builder sources(List<MuleSourceSerializableModel> sourceModelList) {
            this.sourceModelList = new ArrayList<MuleSourceSerializableModel>(sourceModelList);
            return this;
        }

        public Builder valueProviders(List<MuleValueProviderSerializableModel> valueProvidersModelList) {
            this.valueProvidersModelList = new ArrayList<MuleValueProviderSerializableModel>(valueProvidersModelList);
            return this;
        }

        public Builder testConnection(MuleTestConnectionSerializableModel testConnectionModel) {
            this.testConnectionModel = testConnectionModel;
            return this;
        }

        @Override
        public MuleConnectorSerializableModel build() {
            return new MuleConnectorSerializableModel(this.name, this.displayName, this.version, this.description, this.vendor, this.category, this.connectionProviderModelList, this.testConnectionModel, this.operationModelList, this.sourceModelList, this.valueProvidersModelList, this.modelReference);
        }
    }
}

