/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.util;

import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.interpreter.ReaderWriterConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ScriptingBindings;

public class SerializationUtil {
    private final DataWeaveScriptingEngine dataWeaveScriptingEngine;
    private final ModelInterpreterConfig modelInterpreterConfig;
    private static final ReaderWriterConfig READER_TEXT_CONFIG = new ReaderWriterConfig("text/plain", new HashMap<String, Object>());
    private static final ReaderWriterConfig READER_JAVA_CONFIG = new ReaderWriterConfig("application/java", new HashMap<String, Object>());

    public SerializationUtil(DataWeaveScriptingEngine dataWeaveScriptingEngine, ModelInterpreterConfig modelInterpreterConfig) {
        this.dataWeaveScriptingEngine = dataWeaveScriptingEngine;
        this.modelInterpreterConfig = modelInterpreterConfig;
    }

    public @Nullable String serializeObject(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        return this.write("%dw 2.7 import toBase64 from dw::core::Binaries --- toBase64(write(object,'application/dw',{ignoreSchema: true}) as Binary {encoding: \"UTF-8\"})", ScriptingBindings.apply().addBinding("object", object, READER_JAVA_CONFIG.getMimeType(), READER_JAVA_CONFIG.getProperties()), this.modelInterpreterConfig.getServiceManager(), "text/plain", Collections.emptyMap()).getContent().toString();
    }

    public @Nullable Object deserializeObject(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        return this.write("%dw 2.7 import fromBase64 from dw::core::Binaries --- read(fromBase64(object) as Binary {encoding: \"UTF-8\"},'application/dw', { onlyData: true })", ScriptingBindings.apply().addBinding("object", object, READER_TEXT_CONFIG.getMimeType(), READER_TEXT_CONFIG.getProperties()), this.modelInterpreterConfig.getServiceManager(), "application/java", Collections.emptyMap()).getContent();
    }

    private DataWeaveResult write(String script, ScriptingBindings bindings, ServiceManager serviceManager, String outputMimeType, Map<String, Object> properties) {
        scala.collection.immutable.HashMap scalaProperties = new scala.collection.immutable.HashMap();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            scalaProperties = scalaProperties.updated((Object)entry.getKey(), entry.getValue());
        }
        return this.modelInterpreterConfig.getCache().computeIfAbsent(String.valueOf(script.hashCode()), k -> this.dataWeaveScriptingEngine.compile(script, bindings.bindingNames())).write(bindings, serviceManager, outputMimeType, (scala.collection.immutable.Map)scalaProperties);
    }
}

