/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model.provider;

import com.mulesoft.connectivity.linkweave.api.loader.TypeUtils;
import com.mulesoft.connectivity.linkweave.api.model.provider.TypeReferenceExpression;
import com.mulesoft.connectivity.linkweave.api.util.DWTypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.IntConsumer;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.api.tooling.ts.DWType;
import org.mule.weave.v2.api.tooling.ts.IntersectionType;
import org.mule.weave.v2.api.tooling.ts.KeyValuePairType;
import org.mule.weave.v2.api.tooling.ts.ObjectType;
import org.mule.weave.v2.api.tooling.ts.ReferenceType;

public class ObjectFieldSelector
extends TypeReferenceExpression {
    private final String[] path;
    private final boolean relative;

    public ObjectFieldSelector(boolean relative, String ... path) {
        this.relative = relative;
        this.path = Objects.requireNonNull(path);
    }

    public ObjectFieldSelector(boolean relative, List<String> path) {
        this(relative, (String[])path.toArray(String[]::new));
    }

    public String[] getPath() {
        return this.path;
    }

    public boolean isRelative() {
        return this.relative;
    }

    public static ObjectFieldSelector create(String value) {
        if (Objects.requireNonNull(value, "Value cannot be null").isBlank()) {
            throw new IllegalArgumentException("Value cannot be empty");
        }
        SelectorParser parser = new SelectorParser();
        value.codePoints().forEachOrdered(parser);
        if (parser.status == Status.IN_QUOTE) {
            throw new IllegalArgumentException("Never closed quote in path: " + value);
        }
        return parser.toSelector();
    }

    public static ObjectFieldSelector create(boolean relative, List<?> path) {
        return new ObjectFieldSelector(relative, (String[])path.stream().map(o -> (String)o).toArray(String[]::new));
    }

    public String toString() {
        StringJoiner sj = new StringJoiner("/", this.relative ? "" : "/", "");
        for (String p : this.path) {
            sj.add(p);
        }
        return sj.toString();
    }

    public Optional<DWType> evaluateOn(DWType type) {
        int i;
        DWType value = type;
        for (i = 0; i < this.path.length; ++i) {
            String fieldName = this.path[i];
            KeyValuePairType keyValuePairType = ObjectFieldSelector.getFieldByName(type, fieldName).orElse(null);
            if (keyValuePairType == null) {
                return Optional.empty();
            }
            value = keyValuePairType.getValue();
            type = TypeUtils.resolveReferenceType(value);
            if (!(type instanceof ObjectType) && !(type instanceof IntersectionType)) break;
        }
        return i >= this.path.length - 1 ? Optional.of(value) : Optional.empty();
    }

    private static Optional<KeyValuePairType> getFieldByName(DWType type, String name) {
        if (type instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)type;
            return ObjectFieldSelector.getFieldByName(referenceType.resolveType(), name);
        }
        if (type instanceof ObjectType) {
            ObjectType objectType = (ObjectType)type;
            return DWTypeUtils.getFieldByName(objectType, name);
        }
        if (type instanceof IntersectionType) {
            IntersectionType intersectionType = (IntersectionType)type;
            return Arrays.stream(intersectionType.intersectionOf()).flatMap(t -> ObjectFieldSelector.getFieldByName(t, name).stream()).findFirst();
        }
        return Optional.empty();
    }

    public ObjectFieldSelector resolve(ObjectFieldSelector other) {
        if (!other.isRelative()) {
            return other;
        }
        String[] relativePath = other.getPath();
        String[] newPath = new String[this.path.length + relativePath.length];
        int i = 0;
        for (String s : this.path) {
            newPath[i++] = s;
        }
        System.arraycopy(relativePath, 0, newPath, i, relativePath.length);
        return new ObjectFieldSelector(this.isRelative(), newPath);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ObjectFieldSelector)) {
            return false;
        }
        ObjectFieldSelector that = (ObjectFieldSelector)o;
        return this.relative == that.relative && Arrays.equals(this.path, that.path);
    }

    public int hashCode() {
        return Arrays.hashCode(this.path) ^ (this.relative ? -1 : 0);
    }

    private static class SelectorParser
    implements IntConsumer {
        private final List<String> path = new ArrayList<String>();
        Status status = Status.START;
        private final StringBuilder sb = new StringBuilder();
        private boolean relative = true;

        private SelectorParser() {
        }

        @Override
        public void accept(int ch) {
            block0 : switch (this.status) {
                case START: {
                    this.status = Status.NORMAL;
                    if (ch == 47) {
                        this.relative = false;
                        break;
                    }
                }
                case NORMAL: {
                    switch (ch) {
                        case 39: {
                            this.status = Status.IN_QUOTE;
                            break block0;
                        }
                        case 47: {
                            this.path.add(this.sb.toString());
                            this.sb.setLength(0);
                            break block0;
                        }
                    }
                    this.sb.appendCodePoint(ch);
                    break;
                }
                case IN_QUOTE: {
                    if (ch == 39) {
                        this.status = Status.NORMAL;
                        break;
                    }
                    this.sb.appendCodePoint(ch);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown status: " + String.valueOf((Object)this.status));
                }
            }
        }

        public ObjectFieldSelector toSelector() {
            if (!this.sb.isEmpty()) {
                this.path.add(this.sb.toString());
            }
            return new ObjectFieldSelector(this.relative, (String[])this.path.toArray(String[]::new));
        }
    }

    private static enum Status {
        START,
        NORMAL,
        IN_QUOTE;

    }
}

