/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.model.connection.oauth;

import com.mulesoft.connectivity.linkweave.api.model.connection.oauth.OAuth2AuthenticationType;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public class OAuth2ImplicitAuthenticationType
extends OAuth2AuthenticationType {
    private final String authorizationUrl;

    public OAuth2ImplicitAuthenticationType(@Nullable String refreshUrl, List<String> scopes, String authorizationUrl) {
        super(OAuth2AuthenticationType.GrantType.implicit, refreshUrl, scopes);
        Objects.requireNonNull(authorizationUrl, "'authorizationUrl' cannot be null");
        this.authorizationUrl = authorizationUrl;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    @Override
    public String toString() {
        return "OAuth2AuthenticationType{  subType='" + String.valueOf(this.getSubType()) + "', authorizationUrl='" + this.authorizationUrl + "', refreshUrl='" + this.getRefreshUrl() + "', scopes=" + String.valueOf(this.getScopes()) + "}";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuth2ImplicitAuthenticationType that = (OAuth2ImplicitAuthenticationType)o;
        return Objects.equals(this.authorizationUrl, that.authorizationUrl) && Objects.equals(this.getRefreshUrl(), that.getRefreshUrl()) && Objects.equals(this.getScopes(), that.getScopes());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.authorizationUrl, this.getRefreshUrl(), this.getScopes());
    }
}

