/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveCall;
import java.util.Objects;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.runtime.ExecuteResult;

public class DataWeaveLiveValue
implements AutoCloseable {
    protected final ExecuteResult result;
    protected final Supplier<DataWeaveCall> callSupplier;
    private boolean closed = false;

    public DataWeaveLiveValue(ExecuteResult result, Supplier<DataWeaveCall> callSupplier) {
        this.result = Objects.requireNonNull(result, "result");
        this.callSupplier = Objects.requireNonNull(callSupplier, "callSupplier");
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        try {
            this.result.close();
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception while closing DataWeaveLiveValue", e);
        }
        this.closed = true;
    }

    public @Nullable Object run(String scriptText) {
        try (DataWeaveCall call = this.callSupplier.get();){
            Object object = this.bindValue(call).write(scriptText);
            return object;
        }
    }

    public DataWeaveLiveValue execute(String scriptText) {
        try (DataWeaveCall call = this.callSupplier.get();){
            DataWeaveLiveValue dataWeaveLiveValue = this.bindValue(call).execute(scriptText);
            return dataWeaveLiveValue;
        }
    }

    public DataWeaveCall call() {
        DataWeaveCall call = this.callSupplier.get();
        this.bindValue(call);
        call.setCallSupplier(this.callSupplier);
        return call;
    }

    private DataWeaveCall bindValue(DataWeaveCall call) {
        return call.bind("result", this.result);
    }

    public ExecuteResult getExecuteResult() {
        return this.result;
    }
}

