/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.linkweave.api.interpreter;

import com.mulesoft.connectivity.linkweave.api.interpreter.Connection;
import com.mulesoft.connectivity.linkweave.api.interpreter.DataWeaveLiveValue;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreter;
import com.mulesoft.connectivity.linkweave.api.interpreter.ModelInterpreterConfig;
import com.mulesoft.connectivity.linkweave.api.model.Model;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ExecuteResult;
import org.mule.weave.v2.runtime.ScriptingBindings;

public class DataWeaveCall
implements AutoCloseable {
    private final ScriptingBindings bindings = new ScriptingBindings();
    private final ModelInterpreterConfig config;
    private final DataWeaveScriptingEngine dataWeaveEngine;
    private final List<ExecuteResult> closeables = new ArrayList<ExecuteResult>();
    private Supplier<DataWeaveCall> callSupplier;
    private static final ScriptingBindings EMPTY_BINDINGS = ScriptingBindings.apply();

    DataWeaveCall(ModelInterpreterConfig config, DataWeaveScriptingEngine dataWeaveEngine, Supplier<DataWeaveCall> callSupplier) {
        this.config = Objects.requireNonNull(config);
        this.dataWeaveEngine = Objects.requireNonNull(dataWeaveEngine);
        this.callSupplier = Objects.requireNonNull(callSupplier);
    }

    public DataWeaveCall bind(String name, @Nullable Object value) {
        if (value instanceof ExecuteResult) {
            ExecuteResult executeResult = (ExecuteResult)value;
            this.bindings.addBinding(name, executeResult.getResultMaterialized());
        } else if (value instanceof Model) {
            Model model = (Model)value;
            ExecuteResult res = this.resolve(ModelInterpreter.getModelReference(model));
            this.closeables.add(res);
            return this.bind(name, res);
        }
        if (value instanceof Connection) {
            ExecuteResult connectedConnection;
            Connection connection = (Connection)value;
            try (DataWeaveCall call = new DataWeaveCall(this.config, this.dataWeaveEngine, this.callSupplier);){
                connectedConnection = call.bind("provider", connection.getProvider()).bind("info", connection.getInfo()).execute("provider.connect(info)").getExecuteResult();
            }
            this.closeables.add(connectedConnection);
            return this.bind(name, connectedConnection);
        }
        this.bindings.addBinding(name, value, "application/java");
        return this;
    }

    ExecuteResult resolve(String modelReference) {
        return this.execute(this.getFromCacheOrCompile(modelReference, new String[0]), EMPTY_BINDINGS);
    }

    public DataWeaveLiveValue execute(String scriptText) {
        ExecuteResult result;
        DataWeaveScript script = this.getScript(scriptText);
        try {
            result = script.exec(this.bindings, this.config.getServiceManager());
        }
        catch (Exception e) {
            this.logViaDWService(e);
            throw e;
        }
        return new DataWeaveLiveValue(result, this.callSupplier);
    }

    private ExecuteResult execute(DataWeaveScript script, ScriptingBindings emptyBindings) {
        try {
            return script.exec(emptyBindings, this.config.getServiceManager());
        }
        catch (Exception e) {
            this.logViaDWService(e);
            throw e;
        }
    }

    @Nullable Object write(String scriptText) {
        DataWeaveScript script = this.getScript(scriptText);
        try {
            return script.write(this.bindings, this.config.getServiceManager(), "application/java").getContent();
        }
        catch (Exception e) {
            this.logViaDWService(e);
            throw e;
        }
    }

    private DataWeaveScript getScript(String scriptText) {
        return this.getFromCacheOrCompile(scriptText, this.bindings.bindingNames());
    }

    DataWeaveScript getFromCacheOrCompile(String scriptText, String[] names) {
        return this.config.getCache().computeIfAbsent(scriptText, k -> {
            try {
                return this.dataWeaveEngine.compile(scriptText, names);
            }
            catch (Exception e) {
                this.logViaDWService(e);
                throw e;
            }
        });
    }

    void logViaDWService(Exception e) {
        this.dataWeaveEngine.loggingService().exists(service -> {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            service.logError(String.format("Dataweave execution failed: %s", sw));
            return null;
        });
    }

    @Override
    public synchronized void close() {
        Exception primaryException = null;
        for (ExecuteResult closeable : this.closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                if (primaryException == null) {
                    primaryException = e;
                    continue;
                }
                primaryException.addSuppressed(e);
            }
        }
        if (primaryException != null) {
            throw new IllegalStateException("Exception while closing DataWeaveCall", primaryException);
        }
    }

    void setCallSupplier(Supplier<DataWeaveCall> callSupplier) {
        this.callSupplier = callSupplier;
    }
}

