/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.ch.rest.model.billing;

import com.mulesoft.ch.rest.model.billing.EC2InstanceTypeDO;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum WorkerType {
    SHARED("Shared", 0.25),
    REGULAR("Regular", 1.0),
    DOUBLE("Double", 2.0);

    private static final Map<String, WorkerType> workerTypeMap;
    private String type;
    private double workerVal;

    public static WorkerType getByType(String type) {
        return workerTypeMap.get(type);
    }

    private WorkerType(String type, double workerVal) {
        this.type = type;
        this.workerVal = workerVal;
    }

    public String getType() {
        return this.type;
    }

    public double getWorkerVal() {
        return this.workerVal;
    }

    public String getInstanceSize() {
        String instanceType = null;
        switch (this) {
            case SHARED: {
                instanceType = EC2InstanceTypeDO.M1_SMALL.getType();
                break;
            }
            case REGULAR: {
                instanceType = EC2InstanceTypeDO.M1_MEDIUM.getType();
                break;
            }
            case DOUBLE: {
                instanceType = EC2InstanceTypeDO.M1_LARGE.getType();
            }
        }
        return instanceType;
    }

    public static WorkerType getWorkerType(String instanceSize) {
        WorkerType type = REGULAR;
        EC2InstanceTypeDO ec2Type = EC2InstanceTypeDO.getTypeByName(instanceSize);
        if (ec2Type != null) {
            switch (ec2Type) {
                case T1_MICRO: 
                case M1_SMALL: {
                    type = SHARED;
                    break;
                }
                case M1_MEDIUM: {
                    type = REGULAR;
                    break;
                }
                case M1_LARGE: 
                case M1_XLARGE: 
                case M2_XLARGE: 
                case M2_2XLARGE: 
                case M2_4XLARGE: 
                case C1_MEDIUM: 
                case C1_XLARGE: {
                    type = DOUBLE;
                }
            }
        }
        return type;
    }

    static {
        workerTypeMap = new HashMap<String, WorkerType>();
        for (WorkerType type : WorkerType.values()) {
            workerTypeMap.put(type.getType(), type);
        }
    }
}

