/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.cloudhub.client;

import com.mulesoft.ch.rest.model.Application;
import com.mulesoft.ch.rest.model.ApplicationStatus;
import com.mulesoft.ch.rest.model.ApplicationStatusChange;
import com.mulesoft.ch.rest.model.ApplicationUpdateInfo;
import com.mulesoft.ch.rest.model.LogResults;
import com.mulesoft.ch.rest.model.Tenant;
import com.mulesoft.ch.rest.model.TenantResults;
import com.mulesoft.cloudhub.client.CloudHubConnectionI;
import com.mulesoft.cloudhub.client.CloudHubConnectionImpl;
import com.mulesoft.cloudhub.client.CloudHubDomainConnectionI;
import com.mulesoft.cloudhub.client.CloudHubException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public class CloudHubDomainConnectionImpl
extends CloudHubConnectionImpl
implements CloudHubDomainConnectionI {
    private String domain;

    protected CloudHubDomainConnectionImpl(CloudHubConnectionI con, String domain) {
        super(con.getUrl(), con.getUsername(), con.getPassword(), null, false);
        this.domain = domain;
    }

    protected CloudHubDomainConnectionImpl(CloudHubConnectionI con, boolean csAuthentication, String domain) {
        super(con.getUrl(), con.getAccessToken(), con.getEnvironmentId(), false);
        this.domain = domain;
    }

    public CloudHubDomainConnectionImpl(String url, String accessToken, boolean debug) {
        this.accessToken = accessToken;
        this.init(url, debug);
    }

    public CloudHubDomainConnectionImpl(String url, String accessToken, String environmentId, boolean debug) {
        this.accessToken = accessToken;
        this.environmentId = environmentId;
        this.init(url, debug);
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public Application retrieveApplication() throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)this.createApplicationDomainBuilder("").get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return (Application)clientResponse.getEntity(Application.class);
        }
        throw this.buildExpception(clientResponse);
    }

    @Override
    public LogResults retrieveApplicationLog(Map<String, String> queryParams) throws CloudHubException {
        ClientResponse clientResponse;
        WebResource resource = this.createResource("/applications/" + this.domain + "/logs");
        if (queryParams != null && !queryParams.isEmpty()) {
            for (String key : queryParams.keySet()) {
                resource = resource.queryParam(key, queryParams.get(key));
            }
        }
        if (ClientResponse.Status.OK.equals((Object)(clientResponse = (ClientResponse)this.authorizeResource(resource).get(ClientResponse.class)).getClientResponseStatus())) {
            return (LogResults)clientResponse.getEntity(LogResults.class);
        }
        throw this.buildExpception(clientResponse);
    }

    @Override
    public File downloadApplicationLog(Map<String, String> queryParams) throws CloudHubException {
        ClientResponse clientResponse;
        WebResource resource = this.createResource("/applications/" + this.domain + "/logs/download");
        if (queryParams != null && !queryParams.isEmpty()) {
            for (String key : queryParams.keySet()) {
                resource = resource.queryParam(key, queryParams.get(key));
            }
        }
        if (ClientResponse.Status.OK.equals((Object)(clientResponse = (ClientResponse)this.authorizeResource(resource).get(ClientResponse.class)).getClientResponseStatus())) {
            return (File)clientResponse.getEntity(File.class);
        }
        throw this.buildExpception(clientResponse);
    }

    @Override
    public ApplicationStatus retrieveApplicationStatus() throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)this.createApplicationDomainBuilder("status").get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return ApplicationStatus.valueOf((String)((String)clientResponse.getEntity(String.class)));
        }
        throw this.buildExpception(clientResponse);
    }

    @Override
    public void deployApplication(InputStream fileStream, long maxWaitTime) {
        boolean failedBefore = this.failedBefore();
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainBuilder("deploy").type(MediaType.APPLICATION_OCTET_STREAM_TYPE)).post(ClientResponse.class, (Object)fileStream);
        if (!ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            throw this.buildExpception(clientResponse);
        }
        this.waitForFinish(maxWaitTime, failedBefore);
    }

    @Override
    public void deployApplication(File file, long maxWaitTime) {
        try {
            this.deployApplication(new FileInputStream(file), maxWaitTime);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File does not exist", e);
        }
    }

    @Override
    public Application updateApplication(ApplicationUpdateInfo newApplicationInfo) throws CloudHubException {
        Application application = this.retrieveApplication();
        ApplicationUpdateInfo oldApplicationInfo = new ApplicationUpdateInfo(application);
        if (!oldApplicationInfo.equals((Object)newApplicationInfo)) {
            ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainBuilder("").type(MediaType.APPLICATION_JSON_TYPE)).put(ClientResponse.class, (Object)newApplicationInfo);
            if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
                return (Application)clientResponse.getEntity(Application.class);
            }
            throw this.buildExpception(clientResponse);
        }
        return application;
    }

    @Override
    public void updateApplicationStatus(ApplicationStatusChange applicationStatusChange, long maxWaitTime) throws CloudHubException {
        boolean failedBefore = this.failedBefore();
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainBuilder("status").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)applicationStatusChange);
        if (!ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            throw this.buildExpception(clientResponse);
        }
        this.waitForFinish(maxWaitTime, failedBefore);
    }

    @Override
    public void deleteApplication() throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)this.createApplicationDomainBuilder().delete(ClientResponse.class);
        if (!ClientResponse.Status.NO_CONTENT.equals((Object)clientResponse.getClientResponseStatus())) {
            throw this.buildExpception(clientResponse);
        }
    }

    @Override
    public TenantResults retrieveTenants(Integer limit, Integer offset, String query, Boolean enabled) throws CloudHubException {
        ClientResponse clientResponse;
        WebResource resource = this.createResource("/applications/" + this.domain + "/tenants");
        if (limit != null) {
            resource = resource.queryParam("limit", String.valueOf(limit));
        }
        if (offset != null) {
            resource = resource.queryParam("offset", String.valueOf(offset));
        }
        if (enabled != null) {
            resource = resource.queryParam("enabled", enabled.toString());
        }
        if (query != null) {
            resource = resource.queryParam("search", query);
        }
        if (ClientResponse.Status.OK.equals((Object)(clientResponse = (ClientResponse)((WebResource.Builder)this.authorizeResource(resource).type(MediaType.APPLICATION_JSON_TYPE)).get(ClientResponse.class)).getClientResponseStatus())) {
            return (TenantResults)clientResponse.getEntity(TenantResults.class);
        }
        throw this.buildExpception(clientResponse);
    }

    @Override
    public Tenant retrieveTenant(String tenantId) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainTenantBuilder(tenantId).type(MediaType.APPLICATION_JSON_TYPE)).get(ClientResponse.class);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return (Tenant)clientResponse.getEntity(Tenant.class);
        }
        throw this.buildExpception(clientResponse);
    }

    @Override
    public InputStream retrieveTenantClientCertificates(String tenantId) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainTenantBuilder(tenantId + "/openVPNConfigs/").type(MediaType.APPLICATION_JSON_TYPE)).get(ClientResponse.class);
        return (InputStream)clientResponse.getEntity(InputStream.class);
    }

    @Override
    public Tenant createTenant(Tenant tenant) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainTenantBuilder("").type(MediaType.APPLICATION_JSON_TYPE)).post(ClientResponse.class, (Object)tenant);
        if (ClientResponse.Status.CREATED.equals((Object)clientResponse.getClientResponseStatus())) {
            return (Tenant)clientResponse.getEntity(Tenant.class);
        }
        throw this.buildExpception(clientResponse);
    }

    @Override
    public Tenant updateTenant(Tenant tenant) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainTenantBuilder(tenant.getId()).type(MediaType.APPLICATION_JSON_TYPE)).put(ClientResponse.class, (Object)tenant);
        if (ClientResponse.Status.OK.equals((Object)clientResponse.getClientResponseStatus())) {
            return (Tenant)clientResponse.getEntity(Tenant.class);
        }
        throw this.buildExpception(clientResponse);
    }

    @Override
    public void deleteTenant(String tenantId) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainTenantBuilder(tenantId).type(MediaType.APPLICATION_JSON_TYPE)).delete(ClientResponse.class);
        if (!ClientResponse.Status.NO_CONTENT.equals((Object)clientResponse.getClientResponseStatus())) {
            throw this.buildExpception(clientResponse);
        }
    }

    @Override
    public void deleteTenants(List<String> tenantIds) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainTenantBuilder("").type(MediaType.APPLICATION_JSON_TYPE)).delete(ClientResponse.class, tenantIds);
        if (!ClientResponse.Status.NO_CONTENT.equals((Object)clientResponse.getClientResponseStatus())) {
            throw this.buildExpception(clientResponse);
        }
    }

    @Override
    public void deleteTenantClientCertificates(String tenantId) throws CloudHubException {
        ClientResponse clientResponse = (ClientResponse)((WebResource.Builder)this.createApplicationDomainTenantBuilder(tenantId + "/openVPNConfigs/").type(MediaType.APPLICATION_JSON_TYPE)).delete(ClientResponse.class);
        if (!ClientResponse.Status.NO_CONTENT.equals((Object)clientResponse.getClientResponseStatus())) {
            throw this.buildExpception(clientResponse);
        }
    }

    private final WebResource.Builder createApplicationDomainBuilder(String path) {
        return this.createBuilder("applications/" + this.domain + "/" + path);
    }

    private final WebResource.Builder createApplicationDomainBuilder() {
        return this.createBuilder("applications/" + this.domain);
    }

    private final WebResource.Builder createApplicationDomainTenantBuilder(String path) {
        return this.createBuilder("applications/" + this.domain + "/tenants/" + path);
    }

    private void waitForFinish(long maxWaitTime, boolean failedBefore) {
        ApplicationStatus status;
        Application latestApplication;
        if (maxWaitTime == 0L) {
            return;
        }
        if (maxWaitTime == 1L) {
            maxWaitTime = Long.MAX_VALUE;
        }
        long before = System.currentTimeMillis();
        while (System.currentTimeMillis() - before < maxWaitTime) {
            latestApplication = this.retrieveApplication();
            status = latestApplication.getDeploymentUpdateStatus();
            if (!failedBefore && status != null && status.equals((Object)ApplicationStatus.DEPLOY_FAILED)) {
                throw new CloudHubException("Application " + this.domain + " failed to start.", String.valueOf(ClientResponse.Status.EXPECTATION_FAILED.getStatusCode()));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        if ((status = (latestApplication = this.retrieveApplication()).getDeploymentUpdateStatus()) == null && latestApplication.getStatus().equals((Object)ApplicationStatus.STARTED)) {
            return;
        }
        if (status == null && latestApplication.getStatus().equals((Object)ApplicationStatus.UNDEPLOYED)) {
            return;
        }
        if (status.equals((Object)ApplicationStatus.DEPLOY_FAILED)) {
            throw new CloudHubException("Application " + this.domain + " failed to start.", String.valueOf(ClientResponse.Status.EXPECTATION_FAILED.getStatusCode()));
        }
        throw new CloudHubException("CloudHub did not finish the process before the specified time", String.valueOf(ClientResponse.Status.GATEWAY_TIMEOUT.getStatusCode()));
    }

    private boolean failedBefore() {
        ApplicationStatus status = this.retrieveApplication().getDeploymentUpdateStatus();
        return status == null ? false : status.equals((Object)ApplicationStatus.DEPLOY_FAILED);
    }
}

