/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.discovery.core.version;

import com.mulesoft.anypoint.discovery.api.exception.InvalidHotFixVersionException;
import com.mulesoft.anypoint.discovery.api.exception.NotParseableVersionException;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;
import com.mulesoft.anypoint.discovery.api.version.VersionVisitor;

public class NullArtifactVersion
implements ArtifactVersion {
    public int major() {
        return 0;
    }

    public int minor() {
        return 0;
    }

    public int patch() {
        return 0;
    }

    public String value() {
        return "NO-VERSION";
    }

    public int hotFixNumber() {
        throw new InvalidHotFixVersionException("Null version is not a hot fix. #sorry #notsorry");
    }

    public boolean olderThan(ArtifactVersion anotherVersion) {
        return false;
    }

    public boolean isSnapshot() {
        return false;
    }

    public boolean isHotFix() {
        return false;
    }

    public boolean isHotFixOf(ArtifactVersion anotherVersion) {
        return false;
    }

    public boolean isEarlyAccess() {
        return false;
    }

    public boolean isReleaseCandidate() {
        return false;
    }

    public boolean isChPatch() {
        return false;
    }

    public ArtifactVersion release() {
        return this;
    }

    public <T> T accept(VersionVisitor<T> visitor) {
        throw new NotParseableVersionException(this.getClass().getSimpleName() + " cannot be visited.");
    }

    public boolean equals(Object other) {
        return other != null && other instanceof NullArtifactVersion;
    }

    public String toString() {
        return "NullArtifactVersion";
    }
}

