/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.discovery.core.version;

import com.mulesoft.anypoint.discovery.api.exception.InvalidHotFixVersionException;
import com.mulesoft.anypoint.discovery.api.exception.NotParseableVersionException;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;
import com.mulesoft.anypoint.discovery.api.version.VersionVisitor;
import com.mulesoft.anypoint.discovery.core.version.NullArtifactVersion;
import com.mulesoft.anypoint.discovery.core.version.ReleaseVersion;
import com.mulesoft.anypoint.discovery.core.version.comparator.MajorMinorPatchComparator;
import com.mulesoft.anypoint.discovery.core.version.comparator.ModifierComparator;
import com.mulesoft.anypoint.discovery.core.version.comparator.SameVersionSnapshotComparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class InternalArtifactVersion
implements ArtifactVersion {
    private static final Pattern versionRegex = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.([0-9]+)(-(([a-zA-Z]+[0-9]+((-SNAPSHOT)?))|(SNAPSHOT)|([0-9]{8})|(HF-SNAPSHOT)|([0-9]{8}-[0-9]{1,2}|[0-9]{1,2}e?(-java([0-9]{1,2}))?)))?$", 2);
    private final int major;
    private final int minor;
    private final int patch;
    private final boolean isSnapshot;
    private final String modifier;

    InternalArtifactVersion(String version) {
        version = version.toUpperCase();
        if (!InternalArtifactVersion.isValid(version)) {
            throw new NotParseableVersionException("Cannot create version for '" + version + "'.");
        }
        Matcher matcher = versionRegex.matcher(version);
        matcher.matches();
        this.major = Integer.valueOf(matcher.group(1));
        this.minor = Integer.valueOf(matcher.group(2));
        this.patch = Integer.valueOf(matcher.group(3));
        String modifier = matcher.group(4);
        this.modifier = modifier != null ? this.withoutSnapshot(modifier).toLowerCase() : "";
        this.isSnapshot = modifier != null && modifier.toUpperCase().endsWith("-SNAPSHOT");
    }

    public InternalArtifactVersion(int major, int minor, int patch, boolean isSnapshot) {
        this(major + "." + minor + "." + patch + (isSnapshot ? "-SNAPSHOT" : ""));
    }

    public static boolean isValid(String possibleVersion) {
        Matcher matcher = versionRegex.matcher(possibleVersion);
        return matcher.matches();
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public String value() {
        return this.formattedVersion();
    }

    public int hotFixNumber() {
        try {
            return Integer.parseInt(this.modifier.substring(3));
        }
        catch (Exception e) {
            throw new InvalidHotFixVersionException("Version " + this.value() + " is not a valid hot fix version: format must be -hfX where 'X' is an integer.", e);
        }
    }

    public boolean olderThan(ArtifactVersion anotherVersion) {
        String otherModifier;
        if (anotherVersion instanceof NullArtifactVersion) {
            return false;
        }
        InternalArtifactVersion other = (InternalArtifactVersion)anotherVersion;
        int mmpComparison = new MajorMinorPatchComparator().compare(this, anotherVersion);
        if (mmpComparison != 0) {
            return mmpComparison < 0;
        }
        String thisModifier = this.toComparableModifier(this);
        int modifierComparison = new ModifierComparator().compare(thisModifier, otherModifier = this.toComparableModifier(other));
        if (modifierComparison != 0) {
            return modifierComparison < 0;
        }
        int releaseComparison = new SameVersionSnapshotComparator().compare(this.isSnapshot, other.isSnapshot);
        return releaseComparison < 0;
    }

    private String toComparableModifier(InternalArtifactVersion version) {
        return version.isSnapshot && version.modifier.equals("") ? "-" : version.modifier;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public boolean isHotFix() {
        return this.modifier.toUpperCase().startsWith("-HF");
    }

    public boolean isHotFixOf(ArtifactVersion anotherVersion) {
        return this.modifier.startsWith("-hf") && this.modifier.length() > 3 ? new ReleaseVersion(this.major, this.minor, this.patch).equals(anotherVersion) : false;
    }

    public boolean isReleaseCandidate() {
        return this.modifier.startsWith("-rc");
    }

    public boolean isChPatch() {
        return this.modifier.matches("-[0-9]{8}") || this.upperForChPatch(this.modifier).equals("-HF");
    }

    public boolean isEarlyAccess() {
        return this.modifier.startsWith("-ea");
    }

    public ArtifactVersion release() {
        if (this.isChPatch()) {
            throw new InvalidHotFixVersionException("Cannot create release version '" + this.toString() + "' as I'm not sure the date. #whatYearIsIt");
        }
        String newModifier = this.isEarlyAccess() || this.isReleaseCandidate() ? "" : this.modifier;
        return new ReleaseVersion(this.major + "." + this.minor + "." + this.patch + newModifier);
    }

    public abstract <T> T accept(VersionVisitor<T> var1);

    public String toString() {
        return this.formattedVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalArtifactVersion)) {
            return false;
        }
        InternalArtifactVersion that = (InternalArtifactVersion)o;
        return this.formattedVersion().equals(that.formattedVersion());
    }

    public int hashCode() {
        return this.formattedVersion().hashCode();
    }

    private String formattedVersion() {
        return String.format("%d.%d.%d%s%s", this.major, this.minor, this.patch, this.upperForChPatch(this.modifier), this.isSnapshot ? "-SNAPSHOT" : "");
    }

    private String upperForChPatch(String modifier) {
        if (modifier.equals("-hf")) {
            modifier = modifier.toUpperCase();
        }
        return modifier;
    }

    private String withoutSnapshot(String modifier) {
        String substring = modifier;
        int index = this.snapshotIndex(modifier);
        if (index > -1) {
            substring = modifier.substring(0, index);
        }
        return substring != null ? substring : "";
    }

    private int snapshotIndex(String modifier) {
        return modifier != null ? modifier.toUpperCase().indexOf("-SNAPSHOT") : -1;
    }
}

