/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.discovery.core.version;

import com.mulesoft.anypoint.discovery.api.exception.NotParseableVersionException;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersionFactory;
import com.mulesoft.anypoint.discovery.core.version.EarlyAccessVersion;
import com.mulesoft.anypoint.discovery.core.version.MonthlySnapshotVersion;
import com.mulesoft.anypoint.discovery.core.version.MonthlyVersion;
import com.mulesoft.anypoint.discovery.core.version.ReleaseCandidateVersion;
import com.mulesoft.anypoint.discovery.core.version.ReleaseVersion;
import com.mulesoft.anypoint.discovery.core.version.SnapshotVersion;
import com.mulesoft.anypoint.discovery.core.version.UnknownArtifactVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MuleArtifactVersionFactory
implements ArtifactVersionFactory {
    private final Map<Pattern, BiFunction<Matcher, String, ArtifactVersion>> versionPatternMatcher = new HashMap<Pattern, BiFunction<Matcher, String, ArtifactVersion>>();
    public static final String majorMinorPatch = "([0-9]+)\\.([0-9]+)\\.([0-9]+)";
    private static final Pattern snapshotPattern = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.([0-9]+)(-SNAPSHOT)$", 2);
    private static final Pattern monthlySnapshotPattern = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.([0-9]+)(-HF-SNAPSHOT)$", 2);
    private static final Pattern monthlyPattern = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.([0-9]+)(-)([0-9]{8})$", 2);
    private static final Pattern eaPattern = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.([0-9]+)(-ea)([0-9]+)$", 2);
    private static final Pattern rcPattern = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.([0-9]+)(-rc)([0-9]+)$", 2);
    private static final Pattern releasePattern = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.([0-9]+)$", 2);

    public MuleArtifactVersionFactory() {
        this.versionPatternMatcher.put(snapshotPattern, (matcher, version) -> new SnapshotVersion((String)version));
        this.versionPatternMatcher.put(monthlyPattern, (matcher, version) -> new MonthlyVersion(this.mmp((Matcher)matcher), matcher.group(5)));
        this.versionPatternMatcher.put(monthlySnapshotPattern, (matcher, version) -> new MonthlySnapshotVersion(this.mmp((Matcher)matcher)));
        this.versionPatternMatcher.put(eaPattern, (matcher, version) -> new EarlyAccessVersion((String)version));
        this.versionPatternMatcher.put(rcPattern, (matcher, version) -> new ReleaseCandidateVersion((String)version));
        this.versionPatternMatcher.put(releasePattern, (matcher, version) -> new ReleaseVersion((String)version));
    }

    public ArtifactVersion create(String version) {
        return this.versionPatternMatcher.keySet().stream().filter(pattern -> pattern.matcher(version).matches()).map(pattern -> this.versionPatternMatcher.get(pattern).apply(pattern.matcher(version), version)).findFirst().orElse(new UnknownArtifactVersion(version));
    }

    private String mmp(Matcher matcher) {
        if (matcher.matches()) {
            return matcher.group(1) + "." + matcher.group(2) + "." + matcher.group(3);
        }
        throw new NotParseableVersionException("Matcher fail to extract groups. " + matcher);
    }

    public ArtifactVersion create(int major, int minor, int patch, boolean isSnapshot) {
        if (isSnapshot) {
            return new SnapshotVersion(major, minor, patch);
        }
        return new ReleaseVersion(major, minor, patch);
    }
}

