/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.discovery.core.version.comparator;

import java.util.Comparator;

/**
 * Defines the order between snapshots and releases.
 * <p>
 * A version vX-SNAPSHOT is considered older and vX, with 'X' being any valid version.
 */
public class SameVersionSnapshotComparator implements Comparator<Boolean> {

  @Override
  public int compare(Boolean isSnapshot, Boolean anotherIsSnapshot) {
    int isSnapshotValue = isSnapshot ? 0 : 1;
    int anotherIsSnapshotValue = anotherIsSnapshot ? 0 : 1;
    return isSnapshotValue - anotherIsSnapshotValue;
  }
}
