/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.discovery.core.version.comparator;

import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;

import java.util.Comparator;

/**
 * Compares two versions only by the MMP (major.minor.patch).
 * <p>
 * NOTE: Extra information such as the SNAPSHOT and whether it is an MULE|AGW|EE|eaX|rcX|hfX are not taken into
 * account.
 */
public class MajorMinorPatchComparator implements Comparator<ArtifactVersion> {
  @Override
  public int compare(ArtifactVersion aVersion, ArtifactVersion anotherVersion) {
    int comparison = compareNumber(aVersion.major(), anotherVersion.major());

    if (comparison == 0) {
      comparison = compareNumber(aVersion.minor(), anotherVersion.minor());
    }

    if (comparison == 0) {
      comparison = compareNumber(aVersion.patch(), anotherVersion.patch());
    }
    return comparison;
  }

  private int compareNumber(int aNumber, int anotherNumber) {
    return aNumber - anotherNumber;
  }
}
