/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.discovery.core.version.comparator;

import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;

import java.util.Comparator;

/**
 * Comparator for a {@link ArtifactVersion}. Useful when sorting a collection of them.
 */
public class ArtifactVersionComparator implements Comparator<ArtifactVersion> {

  @Override
  public int compare(ArtifactVersion aVersion, ArtifactVersion anotherVersion) {
    boolean isEquals = aVersion.equals(anotherVersion);
    if (isEquals) {
      return 0;
    }

    boolean isOlder = aVersion.olderThan(anotherVersion);
    return isOlder ? -1 : 1;
  }
}
