/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.discovery.core.version;

import com.mulesoft.anypoint.discovery.api.exception.InvalidHotFixVersionException;
import com.mulesoft.anypoint.discovery.api.exception.NotParseableVersionException;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;
import com.mulesoft.anypoint.discovery.api.version.VersionVisitor;

/**
 * Null object pattern of {@link ArtifactVersion}.
 */
public class NullArtifactVersion implements ArtifactVersion {

  @Override
  public int major() {
    return 0;
  }

  @Override
  public int minor() {
    return 0;
  }

  @Override
  public int patch() {
    return 0;
  }

  @Override
  public String value() {
    return "NO-VERSION";
  }

  @Override
  public int hotFixNumber() {
    throw new InvalidHotFixVersionException("Null version is not a hot fix. #sorry #notsorry");
  }

  @Override
  public boolean olderThan(ArtifactVersion anotherVersion) {
    return false;
  }

  @Override
  public boolean isSnapshot() {
    return false;
  }

  @Override
  public boolean isHotFix() {
    return false;
  }

  @Override
  public boolean isHotFixOf(ArtifactVersion anotherVersion) {
    return false;
  }

  @Override
  public boolean isEarlyAccess() {
    return false;
  }

  @Override
  public boolean isReleaseCandidate() {
    return false;
  }

  @Override
  public boolean isChPatch() {
    return false;
  }

  @Override
  public ArtifactVersion release() {
    return this;
  }

  @Override
  public <T> T accept(VersionVisitor<T> visitor) {
    throw new NotParseableVersionException(this.getClass().getSimpleName() + " cannot be visited.");
  }

  @Override
  public boolean equals(Object other) {
    return (other != null) && (other instanceof NullArtifactVersion);
  }

  @Override
  public String toString() {
    return "NullArtifactVersion";
  }
}
