/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.discovery.core.version;

import com.mulesoft.anypoint.discovery.api.version.Monthly;
import com.mulesoft.anypoint.discovery.api.version.VersionVisitor;

public class MonthlyVersion extends InternalArtifactVersion implements Monthly {

  private final String date;

  public MonthlyVersion(String mmp, String date) {
    super(mmp +"-"+ date);
    this.date = date;
  }

  @Override
  public <T> T accept(VersionVisitor<T> visitor) {
    return visitor.visit(this);
  }

  @Override
  public String yyyymmdd() {
    return date;
  }
}
