/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.anypoint.discovery.core.aether;

import java.util.List;

import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Searches for the artifact versions present in the provided list of {@link RemoteRepository} using the {@link RepositorySystem}
 * and {@link RepositorySystemSession}
 */
public class AetherVersionProvider {

  private static final Logger LOGGER = LoggerFactory.getLogger(AetherVersionProvider.class);
  private RepositorySystem repositorySystem;
  private RepositorySystemSession repositorySystemSession;
  private List<RemoteRepository> repositories;

  public AetherVersionProvider(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession,
                               List<RemoteRepository> repositories) {
    this.repositorySystem = repositorySystem;
    this.repositorySystemSession = repositorySystemSession;
    this.repositories = repositories;
  }

  public VersionRangeResult findVersions(Artifact artifact) throws VersionRangeResolutionException {
    LOGGER.trace("Looking for artifact " + artifact.getArtifactId() + " deployed in Nexus, query will be done on repositories: "
        + repositories);
    VersionRangeRequest rangeRequest = new VersionRangeRequest(artifact, repositories, null);
    VersionRangeResult versionRange = repositorySystem.resolveVersionRange(repositorySystemSession, rangeRequest);
    LOGGER.trace("Resulted VersionRange: " + versionRange);
    return versionRange;
  }

}
