/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.discovery.core.version;

import com.mulesoft.anypoint.discovery.api.exception.NotParseableVersionException;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;
import com.mulesoft.anypoint.discovery.core.version.ArtifactVersionComparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class InternalArtifactVersion
implements ArtifactVersion {
    private static final Pattern versionRegex = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.([0-9]+)((-HF[0-9]+)|(-SNAPSHOT)|(-(AGW|MULE|EE)-[0-9]+(-SNAPSHOT)?))?$", 2);
    private final int major;
    private final int minor;
    private final int patch;
    private final boolean isSnapshot;
    private final String modifier;

    InternalArtifactVersion(String version) {
        version = version.toUpperCase();
        if (!InternalArtifactVersion.isValid(version)) {
            throw new NotParseableVersionException("Cannot create version for '" + version + "'.");
        }
        Matcher matcher = versionRegex.matcher(version);
        matcher.matches();
        this.major = Integer.valueOf(matcher.group(1));
        this.minor = Integer.valueOf(matcher.group(2));
        this.patch = Integer.valueOf(matcher.group(3));
        String modifier = matcher.group(4);
        this.modifier = modifier != null ? this.lowerCaseOnHF(modifier) : "";
        this.isSnapshot = this.modifier != null && this.modifier.toUpperCase().endsWith("-SNAPSHOT");
    }

    public InternalArtifactVersion(int major, int minor, int patch, boolean isSnapshot) {
        this(major + "." + minor + "." + patch + (isSnapshot ? "-SNAPSHOT" : ""));
    }

    public static boolean isValid(String possibleVersion) {
        Matcher matcher = versionRegex.matcher(possibleVersion);
        return matcher.matches();
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public String value() {
        return this.formattedVersion();
    }

    public boolean olderThan(ArtifactVersion anotherVersion) {
        return new ArtifactVersionComparator().compare(this, anotherVersion) < 0;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public boolean isSupportIssue() {
        return this.modifier.startsWith("-AGW") || this.modifier.startsWith("-MULE") || this.modifier.startsWith("-EE");
    }

    public boolean isHotFixOf(ArtifactVersion anotherVersion) {
        return this.modifier.startsWith("-hf") ? new InternalArtifactVersion(this.major, this.minor, this.patch, false).equals(anotherVersion) : false;
    }

    public ArtifactVersion release() {
        return this.isSnapshot() ? new InternalArtifactVersion(this.major + "." + this.minor + "." + this.patch + this.modifierWithoutSnapshot()) : this;
    }

    public String toString() {
        return this.formattedVersion();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalArtifactVersion)) {
            return false;
        }
        InternalArtifactVersion that = (InternalArtifactVersion)o;
        return this.formattedVersion().equals(that.formattedVersion());
    }

    public int hashCode() {
        return this.formattedVersion().hashCode();
    }

    private String formattedVersion() {
        return String.format("%d.%d.%d%s", this.major, this.minor, this.patch, this.modifier);
    }

    private String modifierWithoutSnapshot() {
        String substring = this.modifier.substring(0, this.modifier.indexOf("-SNAPSHOT"));
        return substring != null ? substring : "";
    }

    private String lowerCaseOnHF(String modifier) {
        return modifier.startsWith("-HF") ? modifier.toLowerCase() : modifier;
    }
}

