/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.discovery.core.aether;

import com.mulesoft.anypoint.discovery.api.RuntimeVersionProvider;
import com.mulesoft.anypoint.discovery.api.exception.NoLatestVersionFoundException;
import com.mulesoft.anypoint.discovery.api.exception.VersionDiscoveryException;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersion;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersionFactory;
import com.mulesoft.anypoint.discovery.api.version.ArtifactVersionValidator;
import com.mulesoft.anypoint.discovery.core.aether.AetherVersionProvider;
import com.mulesoft.anypoint.discovery.core.aether.Product;
import com.mulesoft.anypoint.discovery.core.version.ArtifactVersionComparator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AetherRuntimeVersionProvider
implements RuntimeVersionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AetherRuntimeVersionProvider.class);
    protected final List<ArtifactVersion> allVersions;
    protected final ArtifactVersion latest;
    protected final ArtifactVersionValidator validator;
    protected final ArtifactVersionFactory factory;
    protected final Artifact artifact;

    public AetherRuntimeVersionProvider(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, List<RemoteRepository> repositories, Product product, ArtifactVersionFactory factory, ArtifactVersionValidator validator) throws VersionDiscoveryException {
        this.factory = factory;
        this.artifact = this.artifact(product);
        this.validator = validator;
        try {
            VersionRangeResult versionRange = new AetherVersionProvider(repositorySystem, repositorySystemSession, repositories).findVersions(this.artifact);
            List releases = this.allVersions(versionRange).filter(version -> !version.isSnapshot()).collect(Collectors.toList());
            List snapshots = this.allVersions(versionRange).filter(version -> version.isSnapshot() && !releases.contains(version.release())).collect(Collectors.toList());
            this.allVersions = new ArrayList(releases);
            this.allVersions.addAll(snapshots);
            this.allVersions.sort(new ArtifactVersionComparator());
            LOGGER.debug("All available versions are: " + this.allVersions);
            if (this.allVersions.size() <= 0) {
                throw new NoLatestVersionFoundException("No highest version has been found in Nexus, VersionRangeResult is: " + versionRange);
            }
            this.latest = this.allVersions.get(this.allVersions.size() - 1);
            LOGGER.debug("Latest version is: " + this.latest);
        }
        catch (VersionRangeResolutionException e) {
            throw new VersionDiscoveryException("An error occurred while resolving versions for product " + (Object)((Object)product), (Throwable)e);
        }
    }

    public List<ArtifactVersion> all() {
        return this.allVersions;
    }

    public ArtifactVersion latest() {
        return this.latest;
    }

    protected Stream<ArtifactVersion> allVersions(VersionRangeResult versionRange) {
        return versionRange.getVersions().stream().filter(this.onlyValids()).map(this.toArtifactVersion()).filter(this.greaterThan411()).distinct();
    }

    public Predicate<Version> onlyValids() {
        return version -> this.validator.isValid(version.toString());
    }

    private Function<Version, ArtifactVersion> toArtifactVersion() {
        return version -> this.factory.create(version.toString());
    }

    public Artifact artifact(Product product) {
        Artifact artifact;
        switch (product) {
            case EE_BOM: {
                artifact = this.muleEEBom();
                break;
            }
            case CE_BOM: {
                artifact = this.muleCEBom();
                break;
            }
            case EE_DISTRO: {
                artifact = this.muleEEDistro();
                break;
            }
            default: {
                artifact = this.muleEEBom();
            }
        }
        return artifact;
    }

    private Predicate<ArtifactVersion> greaterThan411() {
        return version -> !version.olderThan(this.factory.create("4.1.1"));
    }

    private Artifact muleEEBom() {
        return new DefaultArtifact("com.mulesoft.mule.distributions:mule-ee-bom:(0,]");
    }

    private Artifact muleCEBom() {
        return new DefaultArtifact("org.mule.distributions:mule-bom:(0,]");
    }

    private Artifact muleEEDistro() {
        return new DefaultArtifact("com.mulesoft.mule.distributions:mule-ee-distribution-standalone:(0,]");
    }
}

