/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption.encrypter;

import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.model.PolicyProperty;
import com.mulesoft.mule.runtime.gw.policies.encryption.EncryptedValueResult;
import com.mulesoft.mule.runtime.gw.policies.encryption.encrypter.PolicyTypeEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.filter.IdentityManagementFilter;
import com.mulesoft.mule.runtime.gw.policies.encryption.filter.StringTypeFilter;
import java.util.List;
import java.util.Optional;

public class StringEncrypter
extends PolicyTypeEncrypter<String> {
    public StringEncrypter(RuntimeEncrypter runtimeEncrypter, boolean isSensitiveOnlyEnabled, List<PolicyProperty> policyProperties) {
        super(runtimeEncrypter, isSensitiveOnlyEnabled, policyProperties);
    }

    @Override
    protected EncryptedValueResult encryptSingle(String key, String value) {
        String templateValue = String.join((CharSequence)"", "${secure::", key, "}");
        String encrypted = this.encrypt(value);
        return new EncryptedValueResult<String>(key, templateValue, encrypted, encrypted);
    }

    @Override
    protected EncryptedValueResult decryptSingle(String key, String value) {
        String decrypted = this.decrypt(value);
        return new EncryptedValueResult<String>(key, decrypted, decrypted);
    }

    @Override
    protected boolean supports(String key, Optional<PolicyProperty> property) {
        return property.isPresent() && new StringTypeFilter().test(property.get()) || new IdentityManagementFilter().test(key);
    }
}

