/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.template.provider;

import com.google.common.base.Preconditions;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.policies.store.PolicyTemplateStore;
import com.mulesoft.mule.runtime.gw.policies.template.provider.GatewayPolicyTemplateDescriptorFactory;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateAssets;
import com.mulesoft.mule.runtime.gw.policies.template.provider.PolicyTemplateProvider;
import java.io.InputStream;

public class ClasspathPolicyTemplateProvider
extends PolicyTemplateProvider {
    public static final String POLICY_TEMPLATE_FILE_NAME_PATTERN = "%s-mule-policy.jar";
    private final ClassLoader classLoader;

    public ClasspathPolicyTemplateProvider(GatewayPolicyTemplateDescriptorFactory templateDescriptorFactory, PolicyTemplateStore policyTemplateStore) {
        super(templateDescriptorFactory, policyTemplateStore);
        this.classLoader = this.getClass().getClassLoader();
    }

    public ClasspathPolicyTemplateProvider(GatewayPolicyTemplateDescriptorFactory templateDescriptorFactory, PolicyTemplateStore policyTemplateStore, ClassLoader classLoader) {
        super(templateDescriptorFactory, policyTemplateStore);
        this.classLoader = classLoader;
    }

    @Override
    protected PolicyTemplateAssets getPolicyTemplateAssets(PolicyTemplateKey templateKey) {
        String resourceName = String.format(POLICY_TEMPLATE_FILE_NAME_PATTERN, templateKey.getAssetId());
        InputStream resourceStream = this.classLoader.getResourceAsStream(resourceName);
        Preconditions.checkState((resourceStream != null ? 1 : 0) != 0, (Object)String.format("Could not find policy template asset %s for %s", resourceName, templateKey.getAssetId()));
        this.policyTemplateStore.storeInternalJar(templateKey, resourceStream);
        return this.policyTemplateStore.getInternalTemplateAssets(templateKey);
    }
}

