/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption.encrypter;

import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.model.PolicyProperty;
import com.mulesoft.mule.runtime.gw.policies.encryption.EncryptedValueResult;
import com.mulesoft.mule.runtime.gw.policies.encryption.encrypter.PolicyTypeEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.filter.KeyvalueTypeFilter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class KeyvalueEncrypter
extends PolicyTypeEncrypter<Map<String, Object>> {
    public KeyvalueEncrypter(RuntimeEncrypter runtimeEncrypter, boolean isSensitiveOnlyEnabled, List<PolicyProperty> policyProperties) {
        super(runtimeEncrypter, isSensitiveOnlyEnabled, policyProperties);
    }

    @Override
    protected EncryptedValueResult encryptSingle(String rootKey, Map<String, Object> keyvalue) {
        HashMap<String, String> configurationMap = new HashMap<String, String>();
        String key = (String)keyvalue.get("key");
        String value = (String)keyvalue.get("value");
        String encrypted = this.encrypt(value);
        String templateValue = String.join((CharSequence)"", "${secure::", rootKey, ".", key, "}");
        LinkedHashMap<String, String> templateMap = new LinkedHashMap<String, String>();
        templateMap.put("key", key);
        templateMap.put("value", templateValue);
        configurationMap.put("key", key);
        configurationMap.put("value", encrypted);
        return new EncryptedValueResult(rootKey, templateMap, configurationMap, configurationMap);
    }

    @Override
    protected EncryptedValueResult decryptSingle(String key, Map<String, Object> keyvalue) {
        HashMap<String, Object> decrypted = new HashMap<String, Object>();
        decrypted.put("key", keyvalue.get("key"));
        decrypted.put("value", this.decrypt((String)keyvalue.get("value")));
        return new EncryptedValueResult(key, decrypted, decrypted);
    }

    @Override
    protected boolean supports(String key, Optional<PolicyProperty> property) {
        return property.isPresent() && new KeyvalueTypeFilter().test(property.get());
    }
}

