/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service.detection;

import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionBuilder;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.ChangeType;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyAdded;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyReorder;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyRevert;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyUnmodified;
import com.mulesoft.mule.runtime.gw.policies.service.detection.change.PolicyUpdate;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;

public class PolicyChangeInspector {
    public ChangeType detectChange(PolicyDeploymentStatus status, PolicyDefinition newDefinition) {
        if (this.isPolicyOrderUpdate(status, newDefinition)) {
            return new PolicyReorder(status.getAppliedPolicyStatus().get().getPolicyDefinition(), newDefinition);
        }
        if (this.isPolicyRevert(status, newDefinition)) {
            return new PolicyRevert(newDefinition);
        }
        if (this.isTemplateDownloadFailed(status)) {
            if (this.isApplied(status)) {
                return new PolicyUpdate(status.getAppliedPolicyStatus().get().getPolicyDefinition(), newDefinition);
            }
            return new PolicyAdded(newDefinition);
        }
        if (this.isPolicyUpdate(status, newDefinition)) {
            if (this.isApplied(status)) {
                return new PolicyUpdate(status.getAppliedPolicyStatus().get().getPolicyDefinition(), newDefinition);
            }
            return new PolicyAdded(newDefinition);
        }
        return new PolicyUnmodified(newDefinition);
    }

    private boolean isApplied(PolicyDeploymentStatus status) {
        return status.getAppliedPolicyStatus().isPresent();
    }

    private boolean isTemplateDownloadFailed(PolicyDeploymentStatus status) {
        return status.getLatestPolicyStatus().isTemplateDownloadFailed();
    }

    private boolean isPolicyOrderUpdate(PolicyDeploymentStatus status, PolicyDefinition policyDefinition) {
        return status.getAppliedPolicyStatus().isPresent() && !this.sameOrder(status.getAppliedPolicyStatus().get().getPolicyDefinition(), policyDefinition) && this.sameNonOrderConfiguration(status.getAppliedPolicyStatus().get().getPolicyDefinition(), policyDefinition);
    }

    private boolean isPolicyRevert(PolicyDeploymentStatus status, PolicyDefinition policyDefinition) {
        return status.getAppliedPolicyStatus().isPresent() && !this.areEqual(status.getLatestPolicyStatus().getPolicyDefinition(), policyDefinition) && this.areEqual(status.getAppliedPolicyStatus().get().getPolicyDefinition(), policyDefinition);
    }

    private boolean isPolicyUpdate(PolicyDeploymentStatus status, PolicyDefinition policyDefinition) {
        return !this.areEqual(status.getLatestPolicyStatus().getPolicyDefinition(), policyDefinition);
    }

    private boolean areEqual(PolicyDefinition oldDefinition, PolicyDefinition newDefinition) {
        PolicyDefinitionBuilder builder = new PolicyDefinitionBuilder(newDefinition);
        this.ignoreIdentityManagementIfNecessary(oldDefinition, builder);
        return oldDefinition.equals((Object)builder.build());
    }

    private boolean sameOrder(PolicyDefinition oldDefinition, PolicyDefinition policyDefinition) {
        return oldDefinition.getOrder().equals(policyDefinition.getOrder());
    }

    private boolean sameNonOrderConfiguration(PolicyDefinition oldDefinition, PolicyDefinition policyDefinition) {
        PolicyDefinitionBuilder builder = new PolicyDefinitionBuilder(policyDefinition).order(oldDefinition.getOrder());
        this.ignoreIdentityManagementIfNecessary(oldDefinition, builder);
        return oldDefinition.equals((Object)builder.build());
    }

    private void ignoreIdentityManagementIfNecessary(PolicyDefinition latestDefinition, PolicyDefinitionBuilder builder) {
        if (!PolicyDefinitionBuilder.hasIdentityManagementProperties(latestDefinition)) {
            builder.noIdentityManagement();
        }
    }

    private ChangeType ifApplied(PolicyDeploymentStatus status, PolicyDefinition newDefinition, BiFunction<PolicyDefinition, PolicyDefinition, ChangeType> ifFunction, Function<PolicyDefinition, ChangeType> elseFunction) {
        Optional<PolicyDefinitionDeploymentStatus> appliedStatus = status.getAppliedPolicyStatus();
        if (appliedStatus.isPresent()) {
            return ifFunction.apply(appliedStatus.get().getPolicyDefinition(), newDefinition);
        }
        return elseFunction.apply(newDefinition);
    }
}

