/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.service;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyDeploymentTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class DefaultPolicyDeploymentTracker
implements PolicyDeploymentTracker {
    private List<PolicyDeploymentListener> listeners = new LinkedList<PolicyDeploymentListener>();
    private Map<ApiKey, List<PolicyDeploymentStatus>> policies = new HashMap<ApiKey, List<PolicyDeploymentStatus>>();

    @Override
    public List<PolicyDefinition> apiRemoved(ApiKey apiKey) {
        return this.policies.containsKey(apiKey) ? this.policies.remove(apiKey).stream().map(PolicyDeploymentStatus::getLatestPolicyStatus).map(PolicyDefinitionDeploymentStatus::getPolicyDefinition).collect(Collectors.toList()) : Collections.emptyList();
    }

    @Override
    public void addPolicyDeploymentListener(PolicyDeploymentListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void policyRemoved(ApiKey apiKey, String policyName) {
        List<PolicyDeploymentStatus> removedPolicies = this.policies.getOrDefault(apiKey, Collections.emptyList()).stream().filter(status -> this.hasPolicyName((PolicyDeploymentStatus)status, policyName)).collect(Collectors.toList());
        this.policies.getOrDefault(apiKey, Collections.emptyList()).removeIf(policyStatus -> this.hasPolicyName((PolicyDeploymentStatus)policyStatus, policyName));
        removedPolicies.forEach(status -> this.listeners.forEach(listener -> listener.policyRemoved(apiKey, (PolicyDeploymentStatus)status)));
    }

    @Override
    public void policyDeployed(ApiKey apiKey, PolicyDeploymentStatus policyDeploymentStatus) {
        this.policies.putIfAbsent(apiKey, new ArrayList());
        this.policies.get(apiKey).add(policyDeploymentStatus);
        this.listeners.forEach(listener -> listener.policyDeployed(apiKey, policyDeploymentStatus));
    }

    @Override
    public List<PolicyDeploymentStatus> onlinePolicyStatuses(ApiKey apiKey) {
        return this.policies.getOrDefault(apiKey, Collections.emptyList()).stream().filter(status -> status.getLatestPolicyStatus().getPolicyDefinition().isOnline()).collect(Collectors.toList());
    }

    @Override
    public List<PolicyDeploymentStatus> policyStatuses(ApiKey apiKey) {
        return this.policies.getOrDefault(apiKey, Collections.emptyList());
    }

    @Override
    public Optional<PolicyDefinition> findByName(String policyName) {
        return this.policies.values().stream().flatMap(Collection::stream).map(PolicyDeploymentStatus::getLatestPolicyStatus).filter(policyStatus -> policyStatus.getPolicyDefinition().getName().equals(policyName)).map(PolicyDefinitionDeploymentStatus::getPolicyDefinition).findFirst();
    }

    @Override
    public boolean hasDeployments(String policyName) {
        return this.policies.values().stream().flatMap(Collection::stream).map(PolicyDeploymentStatus::getLatestPolicyStatus).anyMatch(policyStatus -> policyStatus.getPolicyDefinition().getName().equals(policyName));
    }

    private boolean hasPolicyName(PolicyDeploymentStatus status, String name) {
        return status.getLatestPolicyStatus().getPolicyDefinition().getName().equals(name);
    }
}

