/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.encryption;

import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySpecification;
import com.mulesoft.mule.runtime.gw.policies.encryption.EncryptedValueResult;
import com.mulesoft.mule.runtime.gw.policies.encryption.PolicyConfigurationEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.PolicyConfigurationEncryptionResult;
import com.mulesoft.mule.runtime.gw.policies.encryption.encrypter.PolicyTypeEncrypter;
import com.mulesoft.mule.runtime.gw.policies.encryption.encrypter.PolicyTypeEncrypters;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPolicyConfigurationEncrypter
implements PolicyConfigurationEncrypter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPolicyConfigurationEncrypter.class);
    private final RuntimeEncrypter runtimeEncrypter;
    private final boolean isSensitiveOnlyEnabled;

    public DefaultPolicyConfigurationEncrypter(RuntimeEncrypter runtimeEncrypter, boolean isSensitiveOnlyEnabled) {
        this.runtimeEncrypter = runtimeEncrypter;
        this.isSensitiveOnlyEnabled = isSensitiveOnlyEnabled;
    }

    @Override
    public PolicyConfigurationEncryptionResult encryptConfiguration(PolicyDefinition policyDefinition, PolicySpecification policySpecification) {
        HashMap<String, Object> templateValues = new HashMap<String, Object>();
        HashMap configurationValues = new HashMap();
        HashMap<String, Object> configFile = new HashMap<String, Object>();
        if (policySpecification.isValid()) {
            PolicyTypeEncrypters encrypters = new PolicyTypeEncrypters(this.runtimeEncrypter, this.isSensitiveOnlyEnabled, policySpecification.getConfiguration());
            policyDefinition.getConfigurationData().getConfiguration().forEach((key, value) -> {
                PolicyTypeEncrypter encrypter = encrypters.getEncrypter((String)key);
                EncryptedValueResult encrypted = encrypter.encrypt((String)key, value);
                templateValues.put((String)key, encrypted.getTemplateValue());
                configurationValues.put(key, encrypted.getConfigurationValue());
                encrypted.getConfigFileValue().ifPresent(o -> configFile.put((String)key, o));
            });
            templateValues.put("encrypted", !configFile.isEmpty());
        } else {
            LOGGER.warn("Encryption of policy {} is disabled, since YAML file is absent or invalid.", (Object)policyDefinition.getName());
        }
        return new PolicyConfigurationEncryptionResult(templateValues, new PolicyConfiguration(configurationValues), configFile);
    }
}

