/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.deployment;

import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.Policy;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.deployment.InternalPolicyDeploymentException;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyFactory;
import com.mulesoft.mule.runtime.gw.policies.factory.PolicyParametrizationFactory;
import com.mulesoft.mule.runtime.gw.policies.template.PolicyTemplate;
import java.util.Collections;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.mule.runtime.core.api.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalPolicyDeployer
implements PolicyDeployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalPolicyDeployer.class);
    private final PolicyFactory policyFactory;
    private final PolicyParametrizationFactory parametrizationFactory;

    public InternalPolicyDeployer(PolicyFactory policyFactory) {
        this.policyFactory = policyFactory;
        this.parametrizationFactory = new PolicyParametrizationFactory();
    }

    @Override
    public PolicyDefinitionDeploymentStatus deploy(PolicyDefinition policyDefinition, Api api) {
        ApiImplementation apiImplementation = api.getImplementation();
        Policy policy = this.policyFactory.createFromPolicyDefinition(policyDefinition);
        ClassUtils.withContextClassLoader((ClassLoader)apiImplementation.getArtifactClassloader(), () -> {
            LOGGER.debug("Deploying internal policy {} for {}", (Object)policyDefinition.getName(), (Object)api);
            try {
                PolicyTemplate policyTemplate = policy.getPolicyTemplate();
                PolicyParametrization policyParametrization = this.parametrizationFactory.create(policyDefinition, apiImplementation, policyTemplate.getTemplateFile(), null, false, Collections.emptyList());
                apiImplementation.addPolicy(policyTemplate.getTemplateDescriptor(), policyParametrization);
            }
            catch (Exception e) {
                LOGGER.error("Error deploying internal policy {} to API {}: {}", new Object[]{policyDefinition.getName(), apiImplementation.getApiKey(), e.getMessage()});
                throw new InternalPolicyDeploymentException("Unexpected error deploying internal policy", e);
            }
        });
        return new PolicyDefinitionDeploymentStatus(policyDefinition);
    }

    @Override
    public PolicyDefinitionDeploymentStatus updateOrder(PolicyDefinition policy, Api api) {
        throw new InternalPolicyDeploymentException("Internal policies should not be reordered");
    }

    @Override
    public boolean undeploy(String policyName, Api api) {
        ApiImplementation apiImplementation = api.getImplementation();
        return (Boolean)ClassUtils.withContextClassLoader((ClassLoader)apiImplementation.getArtifactClassloader(), () -> {
            LOGGER.debug("Removing internal policy {} from {}", (Object)policyName, (Object)api);
            return apiImplementation.removePolicy(this.parametrizationFactory.buildParametrizationId(policyName, apiImplementation));
        });
    }
}

