/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.HttpResourcePointcut;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.OfflinePolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.serialization.OfflinePolicyDeserializationException;
import com.mulesoft.mule.runtime.gw.policies.serialization.PolicyDefinitionDto;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PolicyDefinitionSerializer {
    private ObjectMapper objectMapper = new ObjectMapper();

    public PolicyDefinitionSerializer() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public void serializeToFile(PolicyDefinition policyDefinition, File destFile) throws IOException {
        FileWriter fileWriter = new FileWriter(destFile);
        this.objectMapper.writeValue((Writer)fileWriter, (Object)PolicyDefinitionDto.from(policyDefinition));
    }

    public PolicyDefinition deserializeFromFile(File file) throws IOException {
        PolicyDefinitionDto dto = (PolicyDefinitionDto)this.objectMapper.readValue((Reader)new FileReader(file), PolicyDefinitionDto.class);
        List<HttpResourcePointcut> resourcePointcuts = this.resourcePointcuts(dto);
        PolicyConfiguration policyConfiguration = new PolicyConfiguration(dto.getConfiguration(), dto.getConfigurationVersion());
        return dto.getOnline() ? new PolicyDefinition(dto.getId(), dto.getVersion(), this.adaptDtoKey(dto.getTemplateKey()), this.apiKeys(dto.getApis()), resourcePointcuts, dto.getOrder(), policyConfiguration) : new OfflinePolicyDefinition(dto.getId(), this.adaptDtoKey(dto.getTemplateKey()), this.apiKeys(dto.getApis()), resourcePointcuts, dto.getOrder(), policyConfiguration);
    }

    public OfflinePolicyDefinition deserializeOfflineFromFile(File file) {
        try {
            PolicyDefinitionDto dto = (PolicyDefinitionDto)this.objectMapper.readValue((Reader)new FileReader(file), PolicyDefinitionDto.class);
            this.validateOfflineDefinition(dto);
            List<HttpResourcePointcut> resourcePointcuts = this.resourcePointcuts(dto);
            PolicyConfiguration policyConfiguration = new PolicyConfiguration(dto.getConfiguration());
            return new OfflinePolicyDefinition(this.policyIdFromFile(file), this.adaptDtoKey(dto.getTemplateKey()), this.apiKeys(dto.getApis()), resourcePointcuts, dto.getOrder(), policyConfiguration);
        }
        catch (IOException e) {
            throw new OfflinePolicyDeserializationException("Cannot read offline policy definition from " + String.valueOf(file), e);
        }
    }

    private List<HttpResourcePointcut> resourcePointcuts(PolicyDefinitionDto dto) {
        return dto.getPointcuts() != null ? dto.getPointcuts().getResources().stream().map(resourceDTO -> new HttpResourcePointcut(resourceDTO.getPath(), resourceDTO.getMethod())).collect(Collectors.toList()) : new ArrayList<HttpResourcePointcut>();
    }

    private List<ApiKey> apiKeys(List<PolicyDefinitionDto.APIKeyDTO> apiKeyDTOs) {
        return apiKeyDTOs.stream().map(apiKeyDTO -> new ApiKey(apiKeyDTO.getId())).collect(Collectors.toList());
    }

    private PolicyTemplateKey adaptDtoKey(PolicyDefinitionDto.PolicyTemplateKeyDTO templateKey) {
        return new PolicyTemplateKey(templateKey.getGroupId(), templateKey.getAssetId(), templateKey.getVersion());
    }

    public String policyIdFromFile(File file) {
        return StringUtils.substringBeforeLast((String)file.getName(), (String)".");
    }

    private void validateOfflineDefinition(PolicyDefinitionDto dto) {
        this.validateTemplateKey(dto.getTemplateKey());
        if (dto.getApis() == null) {
            throw new OfflinePolicyDeserializationException("At least one API must be specified");
        }
        dto.getApis().forEach(this::validateApi);
        if (dto.getOrder() <= 0) {
            throw new OfflinePolicyDeserializationException("Order has to be a positive integer");
        }
    }

    private void validateTemplateKey(PolicyDefinitionDto.PolicyTemplateKeyDTO templateKey) {
        if (templateKey == null) {
            throw new OfflinePolicyDeserializationException("Template can not be empty");
        }
        if (StringUtils.isBlank((CharSequence)templateKey.getAssetId()) || StringUtils.isBlank((CharSequence)templateKey.getGroupId()) || StringUtils.isBlank((CharSequence)templateKey.getVersion())) {
            throw new OfflinePolicyDeserializationException("Template's assetId, groupId and version must be present");
        }
    }

    private void validateApi(PolicyDefinitionDto.APIKeyDTO api) {
        if (api == null) {
            throw new OfflinePolicyDeserializationException("API can not be empty");
        }
        if (api.getId() == null) {
            throw new OfflinePolicyDeserializationException("API's id must be present");
        }
    }
}

