/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.api.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.model.gatekeeper.status.GatekeeperStatusTracker;
import com.mulesoft.mule.runtime.gw.notification.ApiContractsListener;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.PolicyDefinitionDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.PolicySetDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.service.PolicyUpdateListener;
import java.util.List;
import java.util.Optional;

public abstract class GateKeeper
implements PolicySetDeploymentListener,
ApiContractsListener,
ApiDeploymentListener,
PolicyUpdateListener {
    protected final ApiService apiService;

    public GateKeeper(ApiService apiService) {
        this.apiService = apiService;
    }

    @Override
    public void onPolicySetDeploymentCompleted(ApiKey apiKey, PolicySet policySet, List<PolicyDefinitionDeploymentStatus> deploymentStatuses) {
        this.getBlockedMonitoredApi(apiKey).ifPresent(api -> {
            GatekeeperStatusTracker status = api.getImplementation().gatekeeperStatus();
            if (this.validOrigin(policySet) && this.everyPolicySuccessfullyApplied(policySet.getPolicyDefinitions(), deploymentStatuses)) {
                status.policiesApplied();
            } else if (this.validOrigin(policySet)) {
                status.policyFailure();
            }
            if (status.shouldUnblock()) {
                this.unblockApi((Api)api);
            }
        });
    }

    public void onContractsLoaded(ApiKey apiKey) {
        this.getMonitoredApi(apiKey).ifPresent(api -> {
            GatekeeperStatusTracker status = api.getImplementation().gatekeeperStatus();
            status.contractsAvailable();
            if (status.shouldUnblock()) {
                this.unblockApi((Api)api);
            }
        });
    }

    public void onContractsRequired(Api api) {
        if (this.isMonitored(api)) {
            api.getImplementation().gatekeeperStatus().contractsRequired();
        }
    }

    public void onNoContractsRequired(Api api) {
        if (this.isMonitored(api)) {
            api.getImplementation().gatekeeperStatus().noContractsRequired();
        }
    }

    protected Optional<Api> getMonitoredApi(ApiKey apiKey) {
        return this.apiService.get(apiKey).filter(this::isMonitored);
    }

    protected Optional<Api> getBlockedMonitoredApi(ApiKey apiKey) {
        return this.getMonitoredApi(apiKey).filter(api -> api.getImplementation().gatekeeperStatus().isBlocked());
    }

    protected boolean everyPolicySuccessfullyApplied(List<PolicyDefinition> policyDefinitions, List<PolicyDefinitionDeploymentStatus> deploymentStatuses) {
        return policyDefinitions.stream().allMatch(policyDefinition -> deploymentStatuses.stream().anyMatch(policyStatus -> policyDefinition.getName().equals(policyStatus.getPolicyDefinition().getName()) && policyStatus.isDeploymentSuccess()));
    }

    protected abstract boolean validOrigin(PolicySet var1);

    protected abstract boolean isMonitored(Api var1);

    protected abstract void blockApi(Api var1);

    protected abstract void unblockApi(Api var1);

    public void onApiDeploymentStart(Api api) {
        if (this.isMonitored(api)) {
            this.blockApi(api);
        }
    }

    protected boolean isHdp(Api api) {
        return api.getImplementation().isHdp();
    }

    protected boolean isBlocked(Api api) {
        return api.getImplementation().gatekeeperStatus().isBlocked();
    }
}

