/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.analytics.cache;

import com.mulesoft.mule.runtime.gw.analytics.cache.AnalyticsEventCache;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueue;
import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueueFactory;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.function.Function;
import org.mapdb.DB;

public class AnalyticsEventCacheFactory {
    private final SizeLimitedQueueFactory factory;
    private final DB regularEventsDb;
    private final DB violationsEventsDb;

    public AnalyticsEventCacheFactory(DB regularEventsDb, DB violationsEventsDb) {
        this.regularEventsDb = regularEventsDb;
        this.violationsEventsDb = violationsEventsDb;
        this.factory = new SizeLimitedQueueFactory();
    }

    public AnalyticsEventCache createRegularEventCache(String name, int cacheCapacity) {
        BlockingQueue regularQueue = this.regularEventsDb.getQueue(name);
        return new AnalyticsEventCache((SizeLimitedQueue<AnalyticsHttpEvent>)this.factory.createCircularQueue((Queue)regularQueue, (long)cacheCapacity), name);
    }

    public AnalyticsEventCache createPolicyViolationsCache(String name, int cacheCapacity, int violationThreshold) {
        BlockingQueue violationsQueue = this.violationsEventsDb.getQueue(name);
        Function<AnalyticsHttpEvent, String> partitioner = event -> {
            Objects.requireNonNull(event.getPolicyViolation(), "Policy violation must be present in the Analytics event for this queue");
            return event.getPolicyViolation().getPolicyId().toString();
        };
        return new AnalyticsEventCache((SizeLimitedQueue<AnalyticsHttpEvent>)this.factory.createCircularPartitionedQueue((Queue)violationsQueue, (long)cacheCapacity, (long)violationThreshold, partitioner), name);
    }
}

