/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model;

import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SplitModelPolicyTemplateKey {
    private static final Pattern SPLIT_MODEL_PATTERN = Pattern.compile("#definition#(.*?)#(.*?)#(.*?)#groupId#(.*)");
    private final PolicyTemplateKey definition;
    private final PolicyTemplateKey implementation;

    public static SplitModelPolicyTemplateKey fromExchangeKey(PolicyTemplateKey key) {
        Matcher matcher = SPLIT_MODEL_PATTERN.matcher(key.getGroupId());
        if (matcher.matches()) {
            PolicyTemplateKey definition = new PolicyTemplateKey(matcher.group(1), matcher.group(2), matcher.group(3));
            PolicyTemplateKey implementation = new PolicyTemplateKey(matcher.group(4), key.getAssetId(), key.getVersion());
            return new SplitModelPolicyTemplateKey(definition, implementation);
        }
        return new SplitModelPolicyTemplateKey(null, key);
    }

    public SplitModelPolicyTemplateKey(PolicyTemplateKey definition, PolicyTemplateKey implementation) {
        this.definition = definition;
        this.implementation = implementation;
    }

    public PolicyTemplateKey definition() {
        return this.definition;
    }

    public PolicyTemplateKey implementation() {
        return this.implementation;
    }

    public String versionInfo() {
        if (this.definition == null) {
            return String.format("version %s", this.implementation.getVersion());
        }
        return String.format("definition version %s (implementation version %s)", this.definition.getVersion(), this.implementation.getVersion());
    }
}

