/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.queue;

import com.mulesoft.mule.runtime.gw.queue.SizeLimitedQueue;
import java.util.Optional;
import java.util.function.Supplier;

public class ConcurrentSizeLimitedQueue<T>
implements SizeLimitedQueue<T> {
    private final SizeLimitedQueue<T> queue;

    ConcurrentSizeLimitedQueue(SizeLimitedQueue<T> queue) {
        this.queue = queue;
    }

    @Override
    public boolean isEmpty() {
        return this.synchronizedExecution(this.queue::isEmpty);
    }

    @Override
    public boolean add(T element) {
        return this.synchronizedExecution(() -> this.queue.add(element));
    }

    @Override
    public Optional<T> retrieve() {
        return this.synchronizedExecution(this.queue::retrieve);
    }

    @Override
    public Optional<T> peek() {
        return this.synchronizedExecution(this.queue::peek);
    }

    @Override
    public void clear() {
        this.synchronizedExecution(this.queue::clear);
    }

    @Override
    public int size() {
        return this.synchronizedExecution(this.queue::size);
    }

    @Override
    public boolean hasCapacity() {
        return this.synchronizedExecution(this.queue::hasCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <F> F synchronizedExecution(Supplier<F> supplier) {
        SizeLimitedQueue<T> sizeLimitedQueue = this.queue;
        synchronized (sizeLimitedQueue) {
            return supplier.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizedExecution(Runnable runnable) {
        SizeLimitedQueue<T> sizeLimitedQueue = this.queue;
        synchronized (sizeLimitedQueue) {
            runnable.run();
        }
    }
}

