/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model.contracts.repository;

import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.internal.encryption.GatewayEncryptionException;
import com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypter;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptedContractsRepository
implements ContractRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptedContractsRepository.class);
    private final ContractRepository decoratee;
    private final RuntimeEncrypter encrypter;

    public EncryptedContractsRepository(ContractRepository decoratee, RuntimeEncrypter encrypter) {
        this.decoratee = decoratee;
        this.encrypter = encrypter;
    }

    @Override
    public void store(ApiKey apiKey, Collection<Contract> contracts) {
        if (contracts.size() > 0) {
            LOGGER.debug("{} contracts will be encrypted before storage.", (Object)contracts.size());
        }
        List<Contract> encryptedContracts = contracts.stream().map(this::encryptContract).collect(Collectors.toList());
        this.decoratee.store(apiKey, encryptedContracts);
    }

    @Override
    public void storeSlas(ApiKey apiKey, Collection<Sla> slas) {
        this.decoratee.storeSlas(apiKey, slas);
    }

    @Override
    public Set<Contract> load(ApiKey apiKey) {
        try {
            LOGGER.debug("Contracts loading and being decrypted.");
            return this.decoratee.load(apiKey).stream().map(this::decryptContract).collect(Collectors.toSet());
        }
        catch (GatewayEncryptionException e) {
            LOGGER.error("Error while trying to decrypt stored contracts. {}.", (Object)ExceptionDescriptor.errorMessage(e));
            return Collections.emptySet();
        }
    }

    @Override
    public void delete(ApiKey apiKey) {
        this.decoratee.delete(apiKey);
    }

    @Override
    public boolean contains(ApiKey apiKey) {
        return this.decoratee.contains(apiKey);
    }

    @Override
    public boolean containsSla(ApiKey apiKey) {
        return this.decoratee.containsSla(apiKey);
    }

    @Override
    public void compact() {
        this.decoratee.compact();
    }

    public void dispose() {
        this.decoratee.dispose();
    }

    private Contract encryptContract(Contract contract) {
        Client encryptedClient = new Client.ClientBuilder().withId(this.encrypter.encrypt(contract.client().id())).withName(this.encrypter.encrypt(contract.client().name())).withSecret(this.encrypter.encrypt(contract.client().secret())).build();
        return new Contract.ContractBuilder().withClient(encryptedClient).withSla(contract.sla()).build();
    }

    private Contract decryptContract(Contract contract) {
        Client encryptedClient = new Client.ClientBuilder().withId(this.encrypter.decrypt(contract.client().id())).withName(this.encrypter.decrypt(contract.client().name())).withSecret(this.encrypter.decrypt(contract.client().secret())).build();
        return new Contract.ContractBuilder().withClient(encryptedClient).withSla(contract.sla()).build();
    }
}

