/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model.contracts;

import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.exception.ForbiddenClientException;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.model.contracts.repository.ContractRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PersistentApiContracts
implements ApiContracts {
    private final ApiContracts decoratee;
    private final ApiKey apiKey;
    private final ContractRepository repository;

    public PersistentApiContracts(ApiKey apiKey, ApiContracts decoratee, ContractRepository repository) {
        this.apiKey = apiKey;
        this.decoratee = decoratee;
        this.repository = repository;
    }

    public void initialise() {
        if (this.repository.contains(this.apiKey)) {
            this.decoratee.updateContracts(new ArrayList<Contract>(this.repository.load(this.apiKey)));
        }
    }

    public ApiContracts updateContracts(List<Contract> contracts) {
        this.decoratee.updateContracts(contracts);
        this.repository.store(this.apiKey, contracts);
        return this;
    }

    public ApiContracts updateSlas(List<Sla> slas) {
        this.decoratee.updateSlas(slas);
        this.repository.storeSlas(this.apiKey, slas);
        return this;
    }

    public ApiContracts updateContracts(Contract ... contracts) {
        return this.updateContracts(Arrays.asList(contracts));
    }

    public Sla sla(Client client) throws ForbiddenClientException {
        return this.decoratee.sla(client);
    }

    public Sla sla(String clientId) throws ForbiddenClientException {
        return this.decoratee.sla(clientId);
    }

    public Client validate(String clientId, String clientSecret) throws ForbiddenClientException {
        return this.decoratee.validate(clientId, clientSecret);
    }

    public Client validate(String clientId) throws ForbiddenClientException {
        return this.decoratee.validate(clientId);
    }

    public List<Contract> contracts() {
        return this.decoratee.contracts();
    }

    public boolean contractsLoaded() {
        return this.decoratee.contractsLoaded();
    }

    public void dispose() {
        this.repository.delete(this.apiKey);
        this.decoratee.dispose();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PersistentApiContracts)) {
            return false;
        }
        PersistentApiContracts that = (PersistentApiContracts)o;
        if (!this.decoratee.equals(that.decoratee)) {
            return false;
        }
        if (!this.apiKey.equals((Object)that.apiKey)) {
            return false;
        }
        return this.repository.equals(that.repository);
    }

    public int hashCode() {
        int result = this.decoratee.hashCode();
        result = 31 * result + this.apiKey.hashCode();
        result = 31 * result + this.repository.hashCode();
        return result;
    }
}

