/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.config;

import com.mulesoft.mule.runtime.gw.api.config.RuntimeConfiguration;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsConfiguration
extends RuntimeConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyticsConfiguration.class);
    private static final String ANALYTICS_URI = "anypoint.platform.analytics_base_uri";
    private static final String ANALYTICS_ENABLED = "anypoint.platform.analytics_enabled";
    private static final String ANALYTICS_ENABLED_DEFAULT = "true";
    private static final String CACHE_FILE = "anypoint.platform.analytics_cache_file";
    private static final String CACHE_FILE_DEFAULT = "api-platform-analytics.db";
    private static final String POLICY_VIOLATIONS_FILE = "anypoint.platform.analytics_policy_violations_file";
    private static final String POLICY_VIOLATIONS_FILE_DEFAULT = "api-platform-analytics-policy-violations.db";
    private static final String CACHE_CAPACITY = "anypoint.platform.analytics_cache_capacity";
    private static final Integer CACHE_CAPACITY_DEFAULT = 50000;
    private static final String POLICY_VIOLATIONS_CACHE_CAPACITY = "anypoint.platform.analytics_policy_violations_cache_capacity";
    private static final Integer POLICY_VIOLATIONS_CACHE_CAPACITY_DEFAULT = 100000;
    private static final String POLICY_VIOLATIONS_THRESHOLD = "anypoint.platform.analytics_policy_violations_threshold";
    private static final Integer POLICY_VIOLATIONS_THRESHOLD_DEFAULT = 10000;
    private static final String PUSH_FREQ = "anypoint.platform.analytics_push_freq";
    private static final Integer PUSH_FREQ_DEFAULT = 5;
    private static final String POLICY_VIOLATIONS_PUSH_FREQ = "anypoint.platform.analytics_policy_violations_push_freq";
    private static final Integer POLICY_VIOLATIONS_PUSH_FREQ_DEFAULT = 5;
    private static final String ANALYTICS_BATCH_SIZE = "anypoint.platform.analytics_batch_size";
    private static final Integer ANALYTICS_BATCH_SIZE_DEFAULT = 50000;
    private static final String ANALYTICS_INCLUDE_CLIENT_IP = "anypoint.platform.analytics_include_client_ip";
    private static final String ANALYTICS_INCLUDE_CLIENT_IP_DEFAULT_VALUE = "true";
    private static final String ANALYTICS_MULTIPLE_CONSUMERS = "anypoint.platform.analytics_multiple_consumers_enabled";
    private static final String ANALYTICS_MULTIPLE_CONSUMERS_DEFAULT = "false";
    private static final String ANALYTICS_MODE = "anypoint.platform.analytics_mode";
    private static final String ANALYTICS_MODE_DEFAULT = "classic";
    private static final String ANALYTICS_SERVICE_MESH_HEADER = "anypoint.platform.analytics_service_mesh_header";
    private static final String ANALYTICS_SERVICE_MESH_HEADER_DEFAULT = "X-MULE-REPORT";
    public static final String ANALYTICS_OUTAGE_STATUS_CODES = "anypoint.platform.analytics_outage_status_codes";
    public static final List<Integer> DEFAULT_ANALYTICS_OUTAGE_STATUS_CODES = Arrays.asList(429, 500, 501, 502, 503, 504);
    private static final String EVENTS_LOGGING_ENABLED = "anypoint.platform.log_analytics_events";
    private static final String EVENTS_LOGGING_ENABLED_DEFAULT = "false";

    public Boolean isEnabled() {
        return Boolean.valueOf(StringUtils.trimToNull((String)System.getProperty(ANALYTICS_ENABLED, "true")));
    }

    public Boolean isServiceMesh() {
        return this.parseModeValue() == Mode.SERVICE_MESH;
    }

    private Mode parseModeValue() {
        String mode = StringUtils.trimToNull((String)System.getProperty(ANALYTICS_MODE, ANALYTICS_MODE_DEFAULT));
        try {
            return Mode.valueOf(mode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("{} is not a valid Analytics configuration mode. Classic mode will be used", (Object)mode);
            return Mode.CLASSIC;
        }
    }

    public String getServiceMeshHeader() {
        return StringUtils.trimToNull((String)System.getProperty(ANALYTICS_SERVICE_MESH_HEADER, ANALYTICS_SERVICE_MESH_HEADER_DEFAULT));
    }

    public Boolean eventsThroughAgentEnabled() {
        return this.isAnalyticsUriSet() == false || this.multipleConsumers();
    }

    public Boolean eventsToCloudEnabled() {
        return this.isAnalyticsUriSet();
    }

    public int getCacheCapacity() {
        return this.parseIntOrDefault(CACHE_CAPACITY, CACHE_CAPACITY_DEFAULT);
    }

    public int getPolicyViolationThreshold() {
        return this.parseIntOrDefault(POLICY_VIOLATIONS_THRESHOLD, POLICY_VIOLATIONS_THRESHOLD_DEFAULT);
    }

    public int getPolicyViolationsCacheCapacity() {
        return this.parseIntOrDefault(POLICY_VIOLATIONS_CACHE_CAPACITY, POLICY_VIOLATIONS_CACHE_CAPACITY_DEFAULT);
    }

    public int getPushFrequency() {
        return this.parseIntOrDefault(PUSH_FREQ, PUSH_FREQ_DEFAULT);
    }

    public int getPolicyViolationsPushFrequency() {
        return this.parseIntOrDefault(POLICY_VIOLATIONS_PUSH_FREQ, POLICY_VIOLATIONS_PUSH_FREQ_DEFAULT);
    }

    public int getAnalyticsEventsBatchSize() {
        int configuredBatchSize = this.parseIntOrDefault(ANALYTICS_BATCH_SIZE, ANALYTICS_BATCH_SIZE_DEFAULT);
        if (configuredBatchSize <= 0) {
            LOGGER.warn("Minimum value for batch size is 1, value specified was {}, setting will be defaulted to 1", (Object)configuredBatchSize);
            configuredBatchSize = 1;
        }
        return configuredBatchSize;
    }

    public File getAnalyticsCacheFile() {
        String policyViolationsFile = System.getProperty(CACHE_FILE);
        return StringUtils.isNotBlank((CharSequence)policyViolationsFile) ? new File(policyViolationsFile) : new File(this.cacheFolder(), CACHE_FILE_DEFAULT);
    }

    public File getAnalyticsPolicyViolationsCacheFile() {
        String policyViolationsFile = System.getProperty(POLICY_VIOLATIONS_FILE);
        return StringUtils.isNotBlank((CharSequence)policyViolationsFile) ? new File(policyViolationsFile) : new File(this.cacheFolder(), POLICY_VIOLATIONS_FILE_DEFAULT);
    }

    public boolean includeClientIp() {
        return Boolean.valueOf(StringUtils.trimToNull((String)System.getProperty(ANALYTICS_INCLUDE_CLIENT_IP, "true")));
    }

    private Boolean isAnalyticsUriSet() {
        return StringUtils.isNotBlank((CharSequence)StringUtils.trimToNull((String)System.getProperty(ANALYTICS_URI)));
    }

    private boolean multipleConsumers() {
        return Boolean.valueOf(StringUtils.trimToNull((String)System.getProperty(ANALYTICS_MULTIPLE_CONSUMERS, "false")));
    }

    private File cacheFolder() {
        File folder = MuleFoldersUtil.getExecutionFolder();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    public List<Integer> getOutagesStatusCodes() {
        return this.parseStatusCodes(StringUtils.trimToNull((String)System.getProperty(ANALYTICS_OUTAGE_STATUS_CODES)));
    }

    private List<Integer> parseStatusCodes(String outageCodes) {
        if (outageCodes == null) {
            return DEFAULT_ANALYTICS_OUTAGE_STATUS_CODES;
        }
        String[] codesAsStrings = outageCodes.split("\\s*,\\s*");
        try {
            return Arrays.stream(codesAsStrings).map(Integer::parseInt).collect(Collectors.toList());
        }
        catch (NumberFormatException var4) {
            LOGGER.error("Could not parse custom analytics outage status codes, value configured: {}", (Object)outageCodes);
            return DEFAULT_ANALYTICS_OUTAGE_STATUS_CODES;
        }
    }

    public Boolean loggingEnabled() {
        return Boolean.valueOf(StringUtils.trimToNull((String)System.getProperty(EVENTS_LOGGING_ENABLED, "false")));
    }

    public static enum Mode {
        CLASSIC,
        SERVICE_MESH;

    }
}

