/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolation;
import com.mulesoft.mule.runtime.gw.api.analytics.PolicyViolationOutcome;
import com.mulesoft.mule.runtime.gw.client.model.HttpEventViews;
import java.io.Serializable;
import java.util.Map;

@JsonAutoDetect
public class PolicyViolationDto
implements Serializable {
    private static final long serialVersionUID = -3999208245432970402L;
    @JsonProperty(value="policy_id")
    private String policyId;
    @JsonProperty(value="outcome")
    private PolicyViolationOutcome outcome;
    @JsonProperty(value="policy_name")
    @JsonView(value={HttpEventViews.ExternalAnalytics.class})
    private String policyName;
    @JsonProperty(value="additional")
    @JsonView(value={HttpEventViews.LogAnalytics.class})
    private Map<String, Object> extraData;

    public PolicyViolationDto(String policyId, PolicyViolationOutcome outcome, String policyName, Map<String, Object> extraData) {
        this.policyId = policyId;
        this.outcome = outcome;
        this.policyName = policyName;
        this.extraData = extraData;
    }

    public static PolicyViolationDto from(PolicyViolation policyViolation) {
        return new PolicyViolationDto(policyViolation.getPolicyId(), policyViolation.getOutcome(), policyViolation.getPolicyName(), policyViolation.getExtraData());
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public PolicyViolationOutcome getOutcome() {
        return this.outcome;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public Map<String, Object> getExtraData() {
        return this.extraData;
    }

    public String toString() {
        return "{outcome=" + String.valueOf(this.outcome) + ", policyId=" + this.policyId + "}";
    }
}

