/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient.interceptors;

import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.HttpRequestResponseInterceptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;

public class TraceInterceptor
implements HttpRequestResponseInterceptor {
    private static final String REQUEST_ID = "request_id";
    private static final List<String> JAR_CONTENT_TYPE = Arrays.asList("application/octet-stream", "application/zip");
    protected final Logger logger;
    private AtomicLong requestNumberSequence = new AtomicLong();

    public TraceInterceptor(Logger logger) {
        this.logger = logger;
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) {
        if (this.logger.isTraceEnabled()) {
            long requestId = this.requestNumberSequence.incrementAndGet();
            httpContext.setAttribute(REQUEST_ID, (Object)requestId);
            this.logRequest(httpRequest, requestId);
        }
    }

    public void process(HttpResponse httpResponse, HttpContext httpContext) {
        if (this.logger.isTraceEnabled()) {
            long requestId = (Long)httpContext.getAttribute(REQUEST_ID);
            this.logResponse(httpResponse, requestId);
        }
    }

    private StringBuilder generateResponseHeader(HttpResponse response, long requestId) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n").append("RESPONSE #").append(requestId).append(": ").append("Status Code: ").append(response.getStatusLine().getStatusCode()).append("\n");
        for (Header header : response.getAllHeaders()) {
            builder.append(header.getName()).append(": ").append(header.getValue()).append("\n");
        }
        builder.append("\n");
        return builder;
    }

    private String buildResponseEntity(HttpResponse response, long requestId) {
        StringBuilder builder = new StringBuilder();
        HttpEntity entity = response.getEntity();
        if (entity != null && entity.getContentType() != null) {
            String contentType = entity.getContentType().getValue();
            if (contentType == null || JAR_CONTENT_TYPE.contains(contentType)) {
                builder.append("This type of payload will not be logged");
            } else {
                try (InputStream contentInputStream = entity.getContent();){
                    if (contentInputStream == null) {
                        builder.append("Unknown payload \n");
                    } else {
                        try {
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            IOUtils.copy((InputStream)contentInputStream, (OutputStream)out);
                            byte[] requestEntity = out.toByteArray();
                            this.printEntity(builder, requestEntity, requestId);
                            response.setEntity((HttpEntity)new WrappedEntity(entity, new ByteArrayInputStream(requestEntity)));
                        }
                        catch (IOException e) {
                            this.logger.trace("An unexpected IO error occurred trying to log response. Reason: " + e.getMessage());
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return builder.toString();
    }

    private void printEntity(StringBuilder builder, byte[] entity, long requestId) {
        if (entity.length > 0) {
            builder.append("\n").append("RESPONSE BODY #").append(requestId).append(": ").append(new String(entity)).append("\n");
        }
    }

    private void logRequest(HttpRequest request, long requestId) {
        HttpEntityEnclosingRequest entityEnclosingRequest;
        StringBuilder builder = this.generateRequestHeader(request, requestId);
        if (request instanceof HttpEntityEnclosingRequest && (entityEnclosingRequest = (HttpEntityEnclosingRequest)request).getEntity() != null) {
            entityEnclosingRequest.setEntity((HttpEntity)new LoggingEntity(entityEnclosingRequest.getEntity(), builder, requestId));
        }
        this.logger.trace(builder.toString());
    }

    private StringBuilder generateRequestHeader(HttpRequest request, long requestId) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n").append("REQUEST #").append(requestId).append(": ").append(this.getUrl(request)).append("\n");
        for (Header header : request.getAllHeaders()) {
            builder.append(header.getName()).append(": ").append(header.getValue()).append("\n");
        }
        return builder;
    }

    private String getUrl(HttpRequest request) {
        if (HttpRequestWrapper.class.isAssignableFrom(request.getClass())) {
            return ((HttpRequestWrapper)request).getOriginal().toString();
        }
        return request.getRequestLine().getMethod() + " " + request.getRequestLine().getUri();
    }

    private void logResponse(HttpResponse response, long requestId) {
        StringBuilder builder = this.generateResponseHeader(response, requestId);
        builder.append(this.buildResponseEntity(response, requestId));
        this.logger.trace(builder.toString());
    }

    public static class WrappedEntity
    extends HttpEntityWrapper {
        private InputStream inputStream;

        public WrappedEntity(HttpEntity entity, InputStream inputStream) {
            super(entity);
            this.inputStream = inputStream;
        }

        public InputStream getContent() {
            return this.inputStream;
        }
    }

    private class LoggingEntity
    extends HttpEntityWrapper {
        private final StringBuilder builder;
        private final long requestId;

        public LoggingEntity(HttpEntity entity, StringBuilder builder, long requestId) {
            super(entity);
            this.builder = builder;
            this.requestId = requestId;
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            super.writeTo((OutputStream)new LoggingOutputStream(outputStream, this.builder, this.requestId));
        }
    }

    private final class LoggingOutputStream
    extends OutputStream {
        private final OutputStream out;
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private final StringBuilder b;
        private final long requestId;

        LoggingOutputStream(OutputStream out, StringBuilder b, long requestId) {
            this.out = out;
            this.b = b;
            this.requestId = requestId;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.baos.write(b);
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.baos.write(b, off, len);
            this.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.baos.write(b);
            this.out.write(b);
        }

        @Override
        public void close() throws IOException {
            TraceInterceptor.this.printEntity(this.b, this.baos.toByteArray(), this.requestId);
            TraceInterceptor.this.logger.trace(this.b.toString());
            this.out.close();
        }
    }
}

