/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient.interceptors;

import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.HttpRequestResponseInterceptor;
import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;

public class BenchmarkInterceptor
implements HttpRequestResponseInterceptor {
    private static final String START_TIME_ATTRIBUTE = "BenchmarkInterceptor.START_TIME";
    private static final String REQUEST_INFO_ATTRIBUTE = "BenchmarkInterceptor.REQUEST_INFO";
    private final Logger logger;

    public BenchmarkInterceptor(Logger logger) {
        this.logger = logger;
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        if (this.logger.isDebugEnabled()) {
            httpContext.setAttribute(REQUEST_INFO_ATTRIBUTE, (Object)(httpRequest.getRequestLine().getMethod() + " " + httpRequest.getRequestLine().getUri()));
            httpContext.setAttribute(START_TIME_ATTRIBUTE, (Object)System.currentTimeMillis());
        }
    }

    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        Long startTime = (Long)httpContext.getAttribute(START_TIME_ATTRIBUTE);
        if (this.logger.isDebugEnabled() && startTime != null) {
            long elapsed = System.currentTimeMillis() - startTime;
            this.logger.debug(String.valueOf(httpContext.getAttribute(REQUEST_INFO_ATTRIBUTE)) + " " + httpResponse.getStatusLine().getStatusCode() + " (took " + elapsed + "ms)");
        }
    }
}

