/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient;

import com.mulesoft.mule.runtime.gw.client.httpclient.connection.RestartableConnectionManager;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.io.function.IOSupplier;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;

public class GatewayHttpClient {
    private final HttpClient httpClient;
    private final RestartableConnectionManager connectionManager;
    private final int timeout;
    private final Timer timer = new Timer(true);
    private final int requestTimeout;

    public GatewayHttpClient(HttpClient httpClient, RestartableConnectionManager connectionManager, int timeout, int requestTimeout) {
        this.httpClient = httpClient;
        this.connectionManager = connectionManager;
        this.timeout = timeout;
        this.requestTimeout = requestTimeout;
    }

    public void cleanConnections() {
        this.connectionManager.closeExpiredConnections();
        this.connectionManager.closeIdleConnections(this.timeout, TimeUnit.MILLISECONDS);
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        return (HttpResponse)this.successOrRestart(() -> this.boundedExecution(request, (IOFunction<HttpUriRequest, HttpResponse>)((IOFunction)arg_0 -> ((HttpClient)this.httpClient).execute(arg_0))));
    }

    private <R> R successOrRestart(IOSupplier<R> procedure) throws IOException {
        try {
            return (R)procedure.get();
        }
        catch (Throwable e) {
            this.connectionManager.restart();
            throw e;
        }
    }

    private HttpResponse boundedExecution(HttpUriRequest request, IOFunction<HttpUriRequest, HttpResponse> function) throws IOException {
        if (this.requestTimeout == 0) {
            return (HttpResponse)function.apply((Object)request);
        }
        TimerTask timerTask = this.hardTimeoutTask(request);
        this.timer.schedule(timerTask, this.requestTimeout);
        HttpResponse response = (HttpResponse)function.apply((Object)request);
        timerTask.cancel();
        this.timer.purge();
        return response;
    }

    private TimerTask hardTimeoutTask(final HttpUriRequest request) {
        return new TimerTask(){

            @Override
            public void run() {
                request.abort();
            }
        };
    }

    public void shutdown() {
        this.connectionManager.shutdown();
        this.timer.cancel();
    }
}

