/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.client.auth.AccessTokenManager;
import com.mulesoft.mule.runtime.gw.client.auth.AccessTokens;
import com.mulesoft.mule.runtime.gw.client.exception.EntityParsingException;
import com.mulesoft.mule.runtime.gw.client.exception.EntityUnparsingException;
import com.mulesoft.mule.runtime.gw.client.exception.HttpConnectionException;
import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.exception.UnauthorizedException;
import com.mulesoft.mule.runtime.gw.client.httpclient.GatewayHttpClient;
import com.mulesoft.mule.runtime.gw.client.model.Authentication;
import com.mulesoft.mule.runtime.gw.client.model.PortalAuthentication;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;

public class ApiPlatformAuthenticator {
    private final URI loginUrl;
    private final URI tokenUrl;
    private final String clientId;
    private final String clientSecret;
    private final ObjectMapper objectMapper;
    private final GatewayHttpClient client;
    private final AccessTokenManager tokenManager;

    public ApiPlatformAuthenticator(GatewayHttpClient client, URI tokenUrl, URI loginUrl, String clientId, String clientSecret) {
        this.tokenUrl = tokenUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.client = client;
        this.loginUrl = loginUrl;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.tokenManager = new AccessTokenManager();
    }

    public AccessTokens authenticate() {
        return this.tokenManager.getUpdatedTokens(this::accessManagementToken, this::apiManagerToken);
    }

    public void unauthorizedUsing(String accessToken) {
        this.tokenManager.resetIfEquals(accessToken);
    }

    String accessManagementToken() {
        try {
            ImmutableList form = ImmutableList.of((Object)new BasicNameValuePair("grant_type", "client_credentials"), (Object)new BasicNameValuePair("client_id", this.clientId), (Object)new BasicNameValuePair("client_secret", this.clientSecret));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity((List)form, "UTF-8");
            HttpResponse response = this.executePost(this.tokenUrl, (HttpEntity)entity);
            return this.processResponse(response, Authentication.class).getAccessToken();
        }
        catch (UnsupportedEncodingException e) {
            throw new EntityParsingException("Error building HTTP Request entity", e);
        }
    }

    PortalAuthentication apiManagerToken(String accessToken) {
        try {
            PortalAuthentication portalAuthentication = new PortalAuthentication();
            portalAuthentication.setToken(accessToken);
            portalAuthentication.setApiGatewayVersion(MuleManifest.getProductVersion());
            HttpResponse response = this.executePost(this.loginUrl, (HttpEntity)new StringEntity(this.objectMapper.writeValueAsString((Object)portalAuthentication), ContentType.APPLICATION_JSON));
            return this.processResponse(response, PortalAuthentication.class);
        }
        catch (JsonProcessingException e) {
            throw new EntityParsingException("Error building HTTP Request entity", (Exception)((Object)e));
        }
    }

    private HttpResponse executePost(URI uri, HttpEntity entity) {
        try {
            HttpPost post = new HttpPost(uri);
            post.setEntity(entity);
            return this.client.execute((HttpUriRequest)post);
        }
        catch (IOException e) {
            throw new HttpConnectionException("An error occurred executing OAuth HTTP Request. " + ExceptionDescriptor.errorMessage((Throwable)e), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T processResponse(HttpResponse response, Class<T> clazz) {
        try (InputStream responseInputStream = response.getEntity().getContent();){
            if (response.getStatusLine().getStatusCode() != 200) {
                String message = response.getStatusLine().getStatusCode() != HttpConstants.HttpStatus.PROXY_AUTHENTICATION_REQUIRED.getStatusCode() ? "Authorization request to Anypoint Platform was not successful, client_id and/or client_secret may be wrong." : "Proxy authorization request failed, configured proxy username and/or password may be wrong.";
                throw new UnauthorizedException(message, IOUtils.toString((InputStream)responseInputStream), response.getStatusLine().getStatusCode());
            }
            T t = this.readResponseValue(response, clazz);
            return t;
        }
        catch (IOException e) {
            throw new HttpResponseException("An error occurred processing OAuth HTTP Response. " + ExceptionDescriptor.errorMessage((Throwable)e), e);
        }
    }

    private <T> T readResponseValue(HttpResponse response, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(response.getEntity().getContent(), clazz);
        }
        catch (IOException e) {
            throw new EntityUnparsingException("Unable to parse HTTP Response content. " + ExceptionDescriptor.errorMessage((Throwable)e), e, response.getStatusLine().getStatusCode());
        }
    }
}

