/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.backoff.session;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.anypoint.retry.session.ErrorSessionMetadata;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformBackoffBarrier
implements BackoffBarrier {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformBackoffBarrier.class);

    @Override
    public boolean shouldBackoff(SessionMetadata sessionMetadata, BackoffConfiguration configuration) {
        boolean hasFailed;
        int requests = sessionMetadata.requests();
        if (requests == 0) {
            return false;
        }
        int failures = this.failureCount(sessionMetadata, configuration.statusCodes());
        double failurePercentage = (double)failures / (double)requests * 100.0;
        boolean bl = hasFailed = failurePercentage >= configuration.failurePercentage();
        if (LOGGER.isDebugEnabled()) {
            String template = "Request failures {}% ({}/{}) {} threshold of {}%";
            if (failures > 0) {
                LOGGER.debug(template, new Object[]{failurePercentage, failures, requests, this.thresholdRelation(hasFailed), configuration.failurePercentage()});
            } else {
                LOGGER.trace(template, new Object[]{failurePercentage, failures, requests, this.thresholdRelation(hasFailed), configuration.failurePercentage()});
            }
        }
        return hasFailed;
    }

    @Override
    public boolean gotError(SessionMetadata sessionMetadata) {
        return sessionMetadata instanceof ErrorSessionMetadata;
    }

    private int failureCount(SessionMetadata sessionMetadata, List<Integer> backoffStatusCodes) {
        return backoffStatusCodes.stream().mapToInt(sessionMetadata::getCount).sum();
    }

    private String thresholdRelation(boolean hasFailed) {
        return hasFailed ? "above or equal to" : "below";
    }
}

