/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.retry;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.anypoint.backoff.scheduler.BackoffScheduler;
import com.mulesoft.anypoint.backoff.scheduler.configuration.FastRecoveryConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.anypoint.backoff.scheduler.observer.FastRecoveryObserver;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.retry.RunnableRetrier;
import com.mulesoft.anypoint.retry.barrier.BackoffRetrierBarrier;
import com.mulesoft.anypoint.retry.barrier.BackoffWhileRetryFails;
import com.mulesoft.anypoint.retry.barrier.BackoffWhilstAlone;
import com.mulesoft.anypoint.retry.exception.RunnableRetrierException;
import com.mulesoft.anypoint.retry.runnable.RetrierRunnable;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mule.runtime.core.api.util.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackoffRunnableRetrier<T>
implements RunnableRetrier<T>,
FastRecoveryObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackoffRunnableRetrier.class);
    private final BackoffConfiguration configuration;
    private final BackoffSchedulerFactory schedulerFactory;
    private final SchedulingConfiguration initialSchedulingConfiguration;
    private final Lock lock = new ReentrantLock();
    private final Map<T, List<Runnable>> runnables = new HashMap<T, List<Runnable>>();
    private final String threadName;
    private BackoffRetrierBarrier barrier;
    private BackoffScheduler scheduler;

    private BackoffRunnableRetrier(String threadName, BackoffConfiguration configuration, BackoffSchedulerFactory schedulerFactory, BackoffRetrierBarrier barrier, SchedulingConfiguration initialSchedulingConfiguration) {
        this.barrier = barrier;
        this.threadName = threadName;
        this.configuration = configuration;
        this.schedulerFactory = schedulerFactory;
        this.initialSchedulingConfiguration = initialSchedulingConfiguration;
        this.checkFastRecovery(this.configuration);
    }

    @Override
    public RunnableRetrier<T> scheduleRetry(T key, Runnable runnable) {
        this.atomically(() -> {
            this.createScheduler();
            this.add(key, runnable);
            try {
                if (this.thereIsOnlyARunnable(key)) {
                    this.schedule(key, runnable);
                } else {
                    LOGGER.trace("There is a runnable running for key {}. Runnable {} will be queued.", key, (Object)runnable.hashCode());
                }
            }
            catch (Throwable t) {
                this.runnables.get(key).remove(runnable);
            }
        });
        return this;
    }

    @Override
    public boolean hasQueuedRunnables(T key) {
        return !this.thereIsOnlyARunnable(key);
    }

    public boolean isIdle(T key) {
        return !this.runnablesPending(key);
    }

    @Override
    public FastRecoveryObserver fastRecoveryUnstable(BackoffRunnable runnable, FastRecoveryConfiguration configuration) {
        LOGGER.trace("BackoffRunnable {} remains unstable, it will be retried with configuration {}.", (Object)runnable, (Object)configuration);
        return this;
    }

    @Override
    public FastRecoveryObserver fastRecoveryStable(BackoffRunnable backoffRunnable, FastRecoveryConfiguration configuration) {
        this.atomically(() -> {
            Runnable runnable = this.asRetrier(backoffRunnable).inner();
            T key = this.asRetrier(backoffRunnable).key();
            this.runnables.get(key).remove(runnable);
            LOGGER.trace("BackoffRunnable {} is now stable, it will be removed. Inner runnable {} has been dropped.", (Object)backoffRunnable, (Object)runnable.hashCode());
            if (!this.runnablesPending()) {
                this.dispose();
            } else if (this.runnablesPending(key)) {
                this.schedule(key, this.runnables.get(key).get(0));
            }
        });
        return this;
    }

    @Override
    public FastRecoveryObserver fastRecoveryAbort(BackoffRunnable backoffRunnable) {
        this.atomically(() -> {
            Runnable runnable = this.asRetrier(backoffRunnable).inner();
            T key = this.asRetrier(backoffRunnable).key();
            this.runnables.get(key).remove(runnable);
            LOGGER.trace("BackoffRunnable {} finished with error, it will be dropped and removed from the queue.", (Object)backoffRunnable);
            if (!this.runnablesPending()) {
                this.dispose();
            } else if (this.runnablesPending(key)) {
                this.schedule(key, this.runnables.get(key).get(0));
            }
        });
        return this;
    }

    public void dispose() {
        if (this.scheduler != null) {
            LOGGER.trace("Disposing BackoffScheduler {}", (Object)this.scheduler.hashCode());
            this.scheduler.dispose();
            this.scheduler = null;
        }
        this.runnables.clear();
    }

    private BackoffRunnable backoffRunnable(T key, Runnable runnable) {
        this.barrier.initialise(key, this);
        return new RetrierRunnable<T>(key, runnable, this.configuration, this.barrier);
    }

    private void add(T key, Runnable runnable) {
        if (!this.runnables.containsKey(key)) {
            this.runnables.put(key, new ArrayList());
        }
        this.runnables.get(key).add(runnable);
    }

    private void schedule(T key, Runnable runnable) {
        BackoffRunnable backoffRunnable = this.backoffRunnable(key, runnable);
        LOGGER.trace("Scheduling runnable {} in BackoffRunnable {} with configuration {}.", new Object[]{runnable.hashCode(), backoffRunnable, this.initialSchedulingConfiguration});
        this.scheduler.schedule(backoffRunnable, this.initialSchedulingConfiguration, this);
    }

    private void createScheduler() {
        if (this.scheduler == null) {
            this.scheduler = this.schedulerFactory.create(Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory(this.threadName)));
            LOGGER.trace("BackoffScheduler {} created using factory {}. Thread pool will be {}.", new Object[]{this.scheduler.hashCode(), this.schedulerFactory.getClass().getSimpleName(), this.threadName});
        }
    }

    private boolean runnablesPending() {
        return this.runnables.keySet().stream().anyMatch(this::runnablesPending);
    }

    private boolean runnablesPending(T key) {
        return Optional.ofNullable(this.runnables.get(key)).map(List::isEmpty).orElse(true) == false;
    }

    private boolean thereIsOnlyARunnable(T key) {
        return this.runnables.get(key).size() == 1;
    }

    private void atomically(Runnable closure) {
        this.lock.lock();
        try {
            closure.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    private RetrierRunnable<T> asRetrier(BackoffRunnable runnable) {
        return (RetrierRunnable)runnable;
    }

    private void checkFastRecovery(BackoffConfiguration backoffConfiguration) {
        if (!backoffConfiguration.isFastRecovery()) {
            throw new RunnableRetrierException("Backoff configuration should be one of fast recovery.");
        }
    }

    public static SchedulingConfiguration delayInitialScheduling(int initialDelay) {
        return SchedulingConfiguration.configuration(Period.seconds((int)initialDelay));
    }

    public static SchedulingConfiguration zeroDelayOnScheduling() {
        return SchedulingConfiguration.configuration(Period.millis((long)0L));
    }

    public static class Builder<T>
    implements com.mulesoft.mule.runtime.gw.api.construction.Builder<BackoffRunnableRetrier<T>> {
        private final String threadName;
        private BackoffConfigurationSupplier configurationSupplier;
        private BackoffRetrierBarrier<T> retrierBarrier;
        private BackoffSchedulerFactory schedulerFactory;
        private final List<Integer> statusCodes;
        private SchedulingConfiguration initialSchedulingConfiguration;
        private final boolean backoffEnabled;

        public Builder(String retrierName, List<Integer> outagesStatusCodes, boolean backoffEnabled) {
            this.threadName = retrierName;
            this.configurationSupplier = new BackoffConfigurationSupplier();
            this.retrierBarrier = new BackoffWhileRetryFails();
            this.statusCodes = outagesStatusCodes;
            this.backoffEnabled = backoffEnabled;
        }

        public Builder<T> retryUntilNewSchedule() {
            this.retrierBarrier = new BackoffWhilstAlone();
            return this;
        }

        public Builder<T> configurationSupplier(BackoffConfigurationSupplier configurationSupplier) {
            this.configurationSupplier = configurationSupplier;
            return this;
        }

        public Builder<T> scheduler(BackoffSchedulerFactory schedulerFactory, SchedulingConfiguration configuration) {
            this.schedulerFactory = schedulerFactory;
            this.initialSchedulingConfiguration = configuration;
            return this;
        }

        public BackoffRunnableRetrier<T> build() {
            return new BackoffRunnableRetrier(this.threadName, this.configurationSupplier.forScheduleOnce(this.statusCodes, this.backoffEnabled), this.schedulerFactory, this.retrierBarrier, this.initialSchedulingConfiguration);
        }
    }
}

