/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.backoff.state;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.SessionMetadata;
import com.mulesoft.anypoint.backoff.state.BackingOff;
import com.mulesoft.anypoint.backoff.state.Error;
import com.mulesoft.anypoint.backoff.state.Stable;
import com.mulesoft.anypoint.backoff.state.State;
import com.mulesoft.anypoint.backoff.state.Unstable;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;

public class BackingOn
extends Unstable {
    public BackingOn(BackoffConfiguration configuration, BackoffBarrier backoffBarrier, int step) {
        super(configuration, backoffBarrier, step);
    }

    @Override
    public State next(SessionMetadata sessionMetadata) {
        if (this.backoffBarrier.gotError(sessionMetadata)) {
            return new Error(this.configuration, this.backoffBarrier, this.step);
        }
        boolean shouldBackoff = this.backoffBarrier.shouldBackoff(sessionMetadata, this.configuration);
        if (!shouldBackoff && this.step == 1) {
            return new Stable(this.configuration, this.backoffBarrier);
        }
        if (shouldBackoff) {
            return new BackingOff(this.configuration, this.backoffBarrier, this.step);
        }
        return new BackingOn(this.configuration, this.backoffBarrier, this.step - 1);
    }

    @Override
    public Period delay() {
        return Period.seconds((int)this.configuration.backon().apply(this.step));
    }

    @Override
    protected String name() {
        return "backon";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackingOn)) {
            return false;
        }
        BackingOn backingOn = (BackingOn)o;
        return this.step == backingOn.step;
    }

    public int hashCode() {
        return this.step;
    }

    public String toString() {
        return "BackingOn{step=" + this.step + '}';
    }
}

