/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.config;

import com.mulesoft.mule.runtime.gw.api.config.RuntimeConfiguration;
import com.mulesoft.mule.runtime.gw.api.exception.GatewayConfigurationException;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;
import com.mulesoft.mule.runtime.gw.internal.encryption.ConfigurationPropertyEncrypter;
import com.mulesoft.mule.runtime.gw.internal.encryption.ConfigurationPropertyEncryptionFactory;
import com.mulesoft.mule.runtime.gw.internal.encryption.GatewayEncryptionException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.LazyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformClientConfiguration
extends RuntimeConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformClientConfiguration.class);
    private static final String CONNECT_TIMEOUT = "anypoint.platform.connect_timeout";
    public static final int CONNECT_TIMEOUT_DEFAULT = 10000;
    private static final String READ_TIMEOUT = "anypoint.platform.read_timeout";
    public static final int READ_TIMEOUT_DEFAULT = 10000;
    public static final String CLIENT_SECRET = "anypoint.platform.client_secret";
    private static final String CLIENT_ID = "anypoint.platform.client_id";
    private static final String IS_ON_PREM = "anypoint.platform.on_prem";
    public static final String POLL_APIS_FREQ = "anypoint.platform.poll_policies_freq";
    private static final int POLL_APIS_FREQ_DEFAULT = 60;
    public static final String POLL_CLIENTS_FREQ = "anypoint.platform.poll_clients_freq";
    private static final int POLL_CLIENTS_FREQ_DEFAULT = 15;
    private static final String POLL_KEEP_ALIVE_FREQ = "anypoint.platform.api_keep_alive_freq";
    private static final int POLL_KEEP_ALIVE_FREQ_DEFAULT = 60;
    private static final String PLATFORM_URI = "anypoint.platform.base_uri";
    private static final String PLATFORM_URI_DEFAULT = "https://anypoint.mulesoft.com";
    private static final String PLATFORM_ENABLE_SSL_VALIDATION = "anypoint.platform.enable_ssl_validation";
    private static final String PLATFORM_ENABLE_SSL_VALIDATION_DEFAULT = "true";
    private static final String PLATFORM_INITIALIZATION_RETRY_FREQ = "anypoint.platform.initialization_retry_freq";
    private static final int PLATFORM_INITIALIZATION_RETRY_FREQ_DEFAULT = 15;
    private static final String ANALYTICS_URI = "anypoint.platform.analytics_base_uri";
    private static final String METRICS_BASE_URI_LEGACY = "anypoint.platform.metrics.base_uri";
    private static final String METRICS_BASE_URI = "anypoint.platform.metrics_base_uri";
    private static final String PROXY_HOST = "anypoint.platform.proxy_host";
    private static final String PROXY_PORT = "anypoint.platform.proxy_port";
    private static final int PROXY_PORT_DEFAULT = 80;
    private static final String PROXY_USERNAME = "anypoint.platform.proxy_username";
    private static final String PROXY_PASSWORD = "anypoint.platform.proxy_password";
    public static final String BACKOFF = "anypoint.platform.backoff";
    private static final String BACKOFF_DEFAULT = "true";
    public static final String OUTAGE_STATUS_CODES = "anypoint.platform.outage_status_codes";
    public static final List<Integer> DEFAULT_OUTAGE_STATUS_CODES = Arrays.asList(400, 401, 403, 405, 429, 502, 503);
    private static final String DEFAULT_POLICY_TEMPLATE_SOURCE = "internal";
    private LazyValue<ConfigurationPropertyEncrypter> encrypter = new LazyValue(() -> ConfigurationPropertyEncryptionFactory.createConfigurationPropertyEncrypter());

    public Boolean enableSSLValidation() {
        return Boolean.valueOf(StringUtils.trimToNull((String)System.getProperty(PLATFORM_ENABLE_SSL_VALIDATION, "true")));
    }

    public Period getConnectTimeout() {
        return Period.millis(this.parsePositive0IntOrDefault(CONNECT_TIMEOUT, 10000));
    }

    public Period getReadTimeout() {
        return Period.millis(this.parsePositive0IntOrDefault(READ_TIMEOUT, 10000));
    }

    public String getProxyHost() {
        return StringUtils.trimToNull((String)System.getProperty(PROXY_HOST));
    }

    public int getProxyPort() {
        return this.parseIntOrDefault(PROXY_PORT, 80);
    }

    public String getProxyUserName() {
        return StringUtils.trimToNull((String)System.getProperty(PROXY_USERNAME));
    }

    public String getProxyPassword() {
        try {
            return ((ConfigurationPropertyEncrypter)this.encrypter.get()).process(StringUtils.trimToNull((String)System.getProperty(PROXY_PASSWORD)));
        }
        catch (GatewayEncryptionException e) {
            throw new GatewayConfigurationException("Proxy Password cannot be decrypted");
        }
    }

    public boolean isOfflineModeEnabled() {
        return StringUtils.trimToNull((String)System.getProperty(CLIENT_ID)) == null || StringUtils.trimToNull((String)System.getProperty(CLIENT_SECRET)) == null;
    }

    public String getClientId() {
        try {
            return ((ConfigurationPropertyEncrypter)this.encrypter.get()).process(StringUtils.trimToNull((String)System.getProperty(CLIENT_ID)));
        }
        catch (GatewayEncryptionException e) {
            throw new GatewayConfigurationException("Client ID cannot be decrypted");
        }
    }

    public String getClientSecret() {
        try {
            return ((ConfigurationPropertyEncrypter)this.encrypter.get()).process(StringUtils.trimToNull((String)System.getProperty(CLIENT_SECRET)));
        }
        catch (GatewayEncryptionException e) {
            throw new GatewayConfigurationException("Client Secret cannot be decrypted");
        }
    }

    public Period getApisPollFrequency() {
        return Period.seconds(this.parseIntOrDefault(POLL_APIS_FREQ, 60));
    }

    public Period getApiKeepAliveFrequency() {
        return Period.seconds(this.parseIntOrDefault(POLL_KEEP_ALIVE_FREQ, 60));
    }

    public Period getClientsPollFrequency() {
        return Period.seconds(this.parseIntOrDefault(POLL_CLIENTS_FREQ, 15));
    }

    public Boolean isOnPrem() {
        return Boolean.valueOf(StringUtils.trimToNull((String)System.getProperty(IS_ON_PREM)));
    }

    public String getPlatformUri() {
        return StringUtils.trimToNull((String)System.getProperty(PLATFORM_URI, PLATFORM_URI_DEFAULT));
    }

    public String getPolicyTemplateSource() {
        return DEFAULT_POLICY_TEMPLATE_SOURCE;
    }

    public void clearClientSecret() {
        System.clearProperty(CLIENT_SECRET);
    }

    public int getPlatformInitializationRetryFrequency() {
        return this.parseIntOrDefault(PLATFORM_INITIALIZATION_RETRY_FREQ, 15);
    }

    public String getAnalyticsUri() {
        return StringUtils.trimToNull((String)System.getProperty(ANALYTICS_URI));
    }

    public String getMetricsBaseUri() {
        return this.parseProperty(METRICS_BASE_URI_LEGACY).orElseGet(() -> this.parseProperty(METRICS_BASE_URI).orElseGet(this::getPlatformUri));
    }

    public Boolean backoffEnabled() {
        return Boolean.valueOf(StringUtils.trimToNull((String)System.getProperty(BACKOFF, "true")));
    }

    public List<Integer> getOutagesStatusCodes() {
        return this.parseStatusCodes(StringUtils.trimToNull((String)System.getProperty(OUTAGE_STATUS_CODES)));
    }

    private Optional<String> parseProperty(String property) {
        return Optional.ofNullable(StringUtils.trimToNull((String)System.getProperty(property)));
    }

    private List<Integer> parseStatusCodes(String outageCodes) {
        if (outageCodes == null) {
            return DEFAULT_OUTAGE_STATUS_CODES;
        }
        String[] codesAsStrings = outageCodes.split("\\s*,\\s*");
        try {
            return Arrays.stream(codesAsStrings).map(Integer::parseInt).collect(Collectors.toList());
        }
        catch (NumberFormatException e) {
            LOGGER.error("Could not parse custom outage status codes, value configured: {}", (Object)outageCodes);
            return DEFAULT_OUTAGE_STATUS_CODES;
        }
    }
}

